/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.BackgroundConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.colors.ColorsConfig;
import net.puffish.skillsmod.util.LegacyUtils;

public class GeneralConfig {
    private final class_2561 title;
    private final IconConfig icon;
    private final BackgroundConfig background;
    private final ColorsConfig colors;
    private final boolean unlockedByDefault;
    private final int startingPoints;
    private final boolean exclusiveRoot;
    private final int spentPointsLimit;

    private GeneralConfig(class_2561 title, IconConfig icon, BackgroundConfig background, ColorsConfig colors, boolean unlockedByDefault, int startingPoints, boolean exclusiveRoot, int spentPointsLimit) {
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.colors = colors;
        this.unlockedByDefault = unlockedByDefault;
        this.startingPoints = startingPoints;
        this.exclusiveRoot = exclusiveRoot;
        this.spentPointsLimit = spentPointsLimit;
    }

    public static Result<GeneralConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> GeneralConfig.parse(rootObject, context), context));
    }

    public static Result<GeneralConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optTitle = rootObject.get("title").andThen(titleElement -> BuiltinJson.parseText(titleElement, (class_5455)context.getServer().method_30611())).ifFailure(problems::add).getSuccess();
        Optional optIcon = rootObject.get("icon").andThen(element -> IconConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        Optional optBackground = rootObject.get("background").andThen(element -> BackgroundConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        ColorsConfig colors = rootObject.get("colors").getSuccess().flatMap(element -> ColorsConfig.parse(element, context).ifFailure(problems::add).getSuccess()).orElseGet(ColorsConfig::createDefault);
        Boolean unlockedByDefault = rootObject.get("unlocked_by_default").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(true);
        Integer startingPoints = rootObject.get("starting_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Boolean exclusiveRoot = rootObject.get("exclusive_root").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(false);
        Integer spentPointsLimit = rootObject.get("spent_points_limit").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(Integer.MAX_VALUE);
        if (problems.isEmpty()) {
            return Result.success(new GeneralConfig((class_2561)optTitle.orElseThrow(), (IconConfig)optIcon.orElseThrow(), (BackgroundConfig)optBackground.orElseThrow(), colors, unlockedByDefault, startingPoints, exclusiveRoot, spentPointsLimit));
        }
        return Result.failure(Problem.combine(problems));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public boolean isUnlockedByDefault() {
        return this.unlockedByDefault;
    }

    public int getStartingPoints() {
        return this.startingPoints;
    }

    public boolean isExclusiveRoot() {
        return this.exclusiveRoot;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public BackgroundConfig getBackground() {
        return this.background;
    }

    public ColorsConfig getColors() {
        return this.colors;
    }

    public int getSpentPointsLimit() {
        return this.spentPointsLimit;
    }
}

