/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.expression.DefaultParser;
import net.puffish.skillsmod.expression.Expression;
import net.puffish.skillsmod.util.LegacyUtils;

public record ExperiencePerLevelConfig(Function<Integer, Integer> function) {
    public static Result<ExperiencePerLevelConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> ExperiencePerLevelConfig.parse(rootObject, context), context));
    }

    public static Result<ExperiencePerLevelConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optTypeElement = rootObject.get("type").ifFailure(problems::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> typeElement.getAsString().ifFailure(problems::add).getSuccess());
        Optional<JsonElement> optData = rootObject.get("data").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return ExperiencePerLevelConfig.build((String)optType.orElseThrow(), optData.orElseThrow(), optTypeElement.orElseThrow().getPath(), context);
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<ExperiencePerLevelConfig, Problem> build(String type, JsonElement dataElement, JsonPath typeElementPath, ConfigContext context) {
        return switch (type) {
            case "expression" -> ExperiencePerLevelConfig.parseExpression(dataElement, context);
            case "values" -> ExperiencePerLevelConfig.parseValues(dataElement, context);
            default -> Result.failure(typeElementPath.createProblem("Expected a valid experience per level type"));
        };
    }

    private static Result<ExperiencePerLevelConfig, Problem> parseExpression(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> ExperiencePerLevelConfig.parseExpression(rootObject, context), context));
    }

    private static Result<ExperiencePerLevelConfig, Problem> parseExpression(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optExpressionElement = rootObject.get("expression").ifFailure(problems::add).getSuccess();
        Optional optExpression = optExpressionElement.flatMap(expressionElement -> expressionElement.getAsString().andThen(expressionString -> DefaultParser.parse(expressionString, Set.of("level"))).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            JsonElement expressionElement2 = optExpressionElement.orElseThrow();
            Expression expression = (Expression)optExpression.orElseThrow();
            return Result.success(new ExperiencePerLevelConfig(level -> {
                Double value = (Double)expression.eval(Map.ofEntries(Map.entry("level", Double.valueOf(level.intValue()))));
                if (Double.isFinite(value)) {
                    return (int)Math.round(value);
                }
                SkillsMod.getInstance().getLogger().warn(expressionElement2.getPath().createProblem("Expression returned a value that is not finite").toString());
                return 0;
            }));
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<ExperiencePerLevelConfig, Problem> parseValues(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> ExperiencePerLevelConfig.parseValues(rootObject, context), context));
    }

    private static Result<ExperiencePerLevelConfig, Problem> parseValues(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optValues = rootObject.getArray("values").andThen(array -> array.getAsList((i, element) -> element.getAsInt()).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            List values = (List)optValues.orElseThrow();
            return Result.success(new ExperiencePerLevelConfig(level -> (Integer)values.get(Math.min(level, values.size() - 1))));
        }
        return Result.failure(Problem.combine(problems));
    }
}

