/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.CategoryConfig;

public abstract class ConfigReader {
    public abstract Result<JsonElement, Problem> read(Path var1);

    public abstract boolean exists(Path var1);

    public Result<Map<ResourceLocation, CategoryConfig>, Problem> readCategories(String namespace, List<String> ids, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        LinkedHashMap map = new LinkedHashMap();
        for (String id : ids) {
            this.readCategory(namespace, id, context).ifSuccess(category -> map.put(ResourceLocation.tryBuild((String)namespace, (String)id), category)).ifFailure(problems::add);
        }
        if (problems.isEmpty()) {
            return Result.success(map);
        }
        return Result.failure(Problem.combine(problems));
    }

    public Result<CategoryConfig, Problem> readCategory(String namespace, String id, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optGeneralElement = this.read(Path.of("categories", id, "category.json")).ifFailure(problems::add).getSuccess();
        Optional<JsonElement> optDefinitionsElement = this.read(Path.of("categories", id, "definitions.json")).ifFailure(problems::add).getSuccess();
        Optional<JsonElement> optSkillsElement = this.read(Path.of("categories", id, "skills.json")).ifFailure(problems::add).getSuccess();
        Optional<JsonElement> optConnectionsElement = this.read(Path.of("categories", id, "connections.json")).ifFailure(problems::add).getSuccess();
        Optional<JsonElement> optExperienceElement = Optional.empty();
        Path experiencePath = Path.of("categories", id, "experience.json");
        if (this.exists(experiencePath)) {
            optExperienceElement = this.read(experiencePath).ifFailure(problems::add).getSuccess();
        }
        if (problems.isEmpty()) {
            return CategoryConfig.parse(ResourceLocation.tryBuild((String)namespace, (String)id), optGeneralElement.orElseThrow(), optDefinitionsElement.orElseThrow(), optSkillsElement.orElseThrow(), optConnectionsElement.orElseThrow(), optExperienceElement, context);
        }
        return Result.failure(Problem.combine(problems));
    }
}

