/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.common.BackgroundPosition;
import org.apache.commons.lang3.RandomStringUtils;

public record ClientBackgroundConfig(ResourceLocation texture, int width, int height, BackgroundPosition position) {
    public static ClientBackgroundConfig create(ResourceLocation textureId, int width, int height, BackgroundPosition position) {
        ResourceLocation id = SkillsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789"));
        ClientBackgroundTexture texture = new ClientBackgroundTexture(textureId);
        Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)texture);
        return new ClientBackgroundConfig(id, width, height, position);
    }

    private static class ClientBackgroundTexture
    extends AbstractTexture
    implements Tickable {
        private final ResourceLocation id;
        private SpriteContents sprite;
        private SpriteTicker animator;

        public ClientBackgroundTexture(ResourceLocation id) {
            this.id = id;
        }

        public void load(ResourceManager manager) {
            this.sprite = manager.getResource(this.id).flatMap(resource -> Optional.ofNullable(SpriteResourceLoader.create((Collection)SpriteLoader.DEFAULT_METADATA_SECTIONS).loadSprite(this.id, resource))).orElseGet(MissingTextureAtlasSprite::create);
            this.animator = this.sprite.createTicker();
            RenderSystem.recordRenderCall(() -> {
                this.bind();
                TextureUtil.prepareImage((int)this.getId(), (int)0, (int)this.sprite.width(), (int)this.sprite.height());
                this.sprite.uploadFirstFrame(0, 0);
            });
        }

        public void tick() {
            this.bind();
            if (this.animator != null) {
                this.animator.tickAndUpload(0, 0);
            }
        }

        public void close() {
            this.sprite.close();
            if (this.animator != null) {
                this.animator.close();
            }
            super.close();
        }
    }
}

