/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillScreenData;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.client.rendering.ConnectionBatchedRenderer;
import net.puffish.skillsmod.client.rendering.ItemBatchedRenderer;
import net.puffish.skillsmod.client.rendering.TextureBatchedRenderer;
import net.puffish.skillsmod.common.BackgroundPosition;
import net.puffish.skillsmod.util.Bounds2i;
import org.joml.Vector2i;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class SkillsScreen
extends Screen {
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("textures/gui/advancements/tabs.png");
    private static final ResourceLocation WINDOW_TEXTURE = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/advancements/widgets.png");
    private static final ResourceLocation RECIPE_BOOK_TEXTURE = new ResourceLocation("textures/gui/recipe_book.png");
    private static final ResourceLocation TRIAL_ICON_TEXTURE = new ResourceLocation("realms", "textures/gui/realms/trial_icon.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private static final Vector4fc COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Vector4fc COLOR_GRAY = new Vector4f(0.25f, 0.25f, 0.25f, 1.0f);
    private final ClientSkillScreenData data;
    private Optional<ClientCategoryData> optActiveCategoryData = Optional.empty();
    private Optional<ResourceLocation> optActiveCategoryId;
    private StateSwitchingButton nextButton;
    private StateSwitchingButton prevButton;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private double dragTotal = 0.0;
    private boolean canDrag = false;
    private Bounds2i bounds = Bounds2i.zero();
    private boolean small = false;
    private int contentPaddingTop = 0;
    private int contentPaddingLeft = 0;
    private int contentPaddingRight = 0;
    private int contentPaddingBottom = 0;

    public SkillsScreen(ClientSkillScreenData data, Optional<ResourceLocation> optCategoryId) {
        super(CommonComponents.f_237098_);
        this.data = data;
        this.optActiveCategoryId = optCategoryId;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.resize();
    }

    public void m_6574_(Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        this.resize();
    }

    private void resize() {
        this.small = this.optActiveCategoryData.map(activeCategoryData -> activeCategoryData.hasExperience() && this.f_96543_ < 450).orElse(false);
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        int halfWidth = this.f_96543_ / 2;
        int halfHeight = this.f_96544_ / 2;
        this.bounds = this.optActiveCategoryData.map(activeCategoryData -> activeCategoryData.getConfig().getBounds()).orElseGet(Bounds2i::zero);
        this.bounds.grow(32);
        this.bounds.extend(new Vector2i(this.contentPaddingLeft - halfWidth, this.contentPaddingTop - halfHeight));
        this.bounds.extend(new Vector2i(this.f_96543_ - halfWidth - this.contentPaddingRight, this.f_96544_ - halfHeight - this.contentPaddingBottom));
        int contentWidth = this.f_96543_ - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.f_96544_ - this.contentPaddingTop - this.contentPaddingBottom;
        if (this.bounds.width() * contentHeight > contentWidth * this.bounds.height()) {
            int halfSize = Mth.m_184652_((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
            this.bounds.extendY(-halfSize);
            this.bounds.extendY(halfSize);
        } else {
            int halfSize = Mth.m_184652_((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
            this.bounds.extendX(-halfSize);
            this.bounds.extendX(halfSize);
        }
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.optActiveCategoryData.ifPresent(activeCategoryData -> this.applyChangesWithLimits(activeCategoryData.getX(), activeCategoryData.getY(), activeCategoryData.getScale(), (ClientCategoryData)activeCategoryData));
        this.nextButton = new StateSwitchingButton(this.f_96543_ - 8 - 12, 16, 12, 17, false){

            public void m_5716_(double mouseX, double mouseY) {
                SkillsScreen.this.data.incrementOffset();
            }
        };
        this.nextButton.m_94624_(1, 208, 13, 18, RECIPE_BOOK_TEXTURE);
        this.prevButton = new StateSwitchingButton(8, 16, 12, 17, true){

            public void m_5716_(double mouseX, double mouseY) {
                SkillsScreen.this.data.decrementOffset();
            }
        };
        this.prevButton.m_94624_(1, 208, 13, 18, RECIPE_BOOK_TEXTURE);
    }

    private Vector2i getMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)mouseX, (int)mouseY);
    }

    private Vector2i getTransformedMousePos(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        return new Vector2i((int)Math.round((mouseX - (double)activeCategoryData.getX() - (double)this.f_96543_ / 2.0) / (double)activeCategoryData.getScale()), (int)Math.round((mouseY - (double)activeCategoryData.getY() - (double)this.f_96544_ / 2.0) / (double)activeCategoryData.getScale()));
    }

    private boolean isInsideTab(Vector2i mouse, int x) {
        return mouse.x >= x && mouse.y >= 8 && mouse.x < x + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vector2i transformedMouse, ClientSkillConfig skill, ClientSkillDefinitionConfig definition) {
        int halfSize = Math.round(13.0f * definition.size());
        return transformedMouse.x >= skill.x() - halfSize && transformedMouse.y >= skill.y() - halfSize && transformedMouse.x < skill.x() + halfSize && transformedMouse.y < skill.y() + halfSize;
    }

    private boolean isInsideContent(Vector2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.f_96543_ - this.contentPaddingRight && mouse.y < this.f_96544_ - this.contentPaddingBottom;
    }

    private boolean isInsideExperience(Vector2i mouse, int x, int y) {
        return mouse.x >= x && mouse.y >= y && mouse.x < x + 182 && mouse.y < y + 5;
    }

    private boolean isInsideArea(Vector2i mouse, int x1, int y1, int x2, int y2) {
        return mouse.x >= x1 && mouse.y >= y1 && mouse.x < x2 && mouse.y < y2;
    }

    private void syncCategory() {
        Optional opt = this.optActiveCategoryId.flatMap(this.data::getCategory);
        opt.ifPresent(ClientCategoryData::updateLastOpen);
        if (this.optActiveCategoryData.isEmpty() || this.optActiveCategoryData.orElseThrow() != opt.orElse(null)) {
            this.optActiveCategoryData = this.data.getCategories().stream().max(Comparator.comparing(ClientCategoryData::getLastOpen));
            this.optActiveCategoryId = this.optActiveCategoryData.map(data -> data.getConfig().id());
            this.resize();
        }
        this.optActiveCategoryData.ifPresent(ClientCategoryData::updateUnseenPoints);
    }

    private int getTabX(int i) {
        return 8 + (i - this.data.getOffset()) * 32 + (this.data.getOffset() > 0 ? 15 : 0);
    }

    private void forEachVisibleTab(BiConsumer<Integer, ClientCategoryData> consumer) {
        Iterator<ClientCategoryData> it = this.data.getCategories().iterator();
        int i = 0;
        while (it.hasNext()) {
            ClientCategoryData category = it.next();
            int x = this.getTabX(i);
            if (x >= 8 && x + 28 <= this.f_96543_ - 8 - 12 - 3) {
                consumer.accept(x, category);
            }
            ++i;
        }
    }

    private boolean hasNextButton() {
        int x = this.getTabX(this.data.getCategories().size() - 1);
        return x + 28 > this.f_96543_ - 8 - 12 - 3;
    }

    private boolean hasPrevButton() {
        return this.data.getOffset() > 0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.optActiveCategoryData.ifPresent(activeCategoryData -> this.mouseClickedWithCategory(mouseX, mouseY, (ClientCategoryData)activeCategoryData));
        }
        if (this.hasNextButton()) {
            this.nextButton.m_6375_(mouseX, mouseY, button);
        }
        if (this.hasPrevButton()) {
            this.prevButton.m_6375_(mouseX, mouseY, button);
        }
        return true;
    }

    private void mouseClickedWithCategory(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            this.dragStartX = mouseX - (double)activeCategoryData.getX();
            this.dragStartY = mouseY - (double)activeCategoryData.getY();
            this.dragTotal = 0.0;
            this.canDrag = true;
        } else {
            this.canDrag = false;
        }
        this.forEachVisibleTab((x, category) -> {
            if (this.isInsideTab(mouse, (int)x)) {
                this.optActiveCategoryId = Optional.ofNullable(category.getConfig().id());
                this.syncCategory();
            }
        });
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.dragTotal > 2.0) {
                return true;
            }
            this.optActiveCategoryData.ifPresent(activeCategoryData -> this.mouseReleasedWithCategory(mouseX, mouseY, (ClientCategoryData)activeCategoryData));
        }
        return true;
    }

    private void mouseReleasedWithCategory(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY, activeCategoryData);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        if (this.isInsideContent(mouse)) {
            for (ClientSkillConfig skill : activeCategory.skills().values()) {
                ClientSkillDefinitionConfig definition = activeCategory.definitions().get(skill.definitionId());
                if (definition == null || !this.isInsideSkill(transformedMouse, skill, definition)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(new SkillClickOutPacket(activeCategory.id(), skill.id()));
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.syncCategory();
        this.m_7333_(matrices);
        this.drawContent(matrices, mouseX, mouseY);
        this.drawWindow(matrices, mouseX, mouseY);
        this.drawTabs(matrices, mouseX, mouseY, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.canDrag) {
            return true;
        }
        if (button == 0) {
            this.dragTotal += Math.abs(deltaX);
            this.dragTotal += Math.abs(deltaY);
            if (this.dragTotal > 2.0) {
                this.optActiveCategoryData.ifPresent(activeCategoryData -> this.applyChangesWithLimits((int)Math.round(mouseX - this.dragStartX), (int)Math.round(mouseY - this.dragStartY), activeCategoryData.getScale(), (ClientCategoryData)activeCategoryData));
            }
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.optActiveCategoryData.ifPresent(activeCategoryData -> {
            float factor = (float)Math.pow(2.0, amount * 0.25);
            int x = activeCategoryData.getX();
            int y = activeCategoryData.getY();
            float scale = activeCategoryData.getScale();
            if ((scale *= factor) < this.minScale) {
                scale = this.minScale;
                factor = this.minScale / scale;
            }
            if (scale > this.maxScale) {
                scale = this.maxScale;
                factor = this.maxScale / scale;
            }
            this.applyChangesWithLimits(x - (int)Math.round((double)(factor - 1.0f) * (mouseX - (double)x - (double)((float)this.f_96543_ / 2.0f))), y - (int)Math.round((double)(factor - 1.0f) * (mouseY - (double)y - (double)((float)this.f_96544_ / 2.0f))), scale, (ClientCategoryData)activeCategoryData);
        });
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private void applyChangesWithLimits(int x, int y, float scale, ClientCategoryData activeCategoryData) {
        int halfWidth = this.f_96543_ / 2;
        int halfHeight = this.f_96544_ / 2;
        scale = Mth.m_14036_((float)scale, (float)this.minScale, (float)this.maxScale);
        activeCategoryData.setX(Mth.m_14045_((int)x, (int)((int)Math.ceil((float)(halfWidth - this.contentPaddingRight) - (float)this.bounds.max().x() * scale)), (int)((int)Math.floor((float)(this.contentPaddingLeft - halfWidth) - (float)this.bounds.min().x() * scale))));
        activeCategoryData.setY(Mth.m_14045_((int)y, (int)((int)Math.ceil((float)(halfHeight - this.contentPaddingBottom) - (float)this.bounds.max().y() * scale)), (int)((int)Math.floor((float)(this.contentPaddingTop - halfHeight) - (float)this.bounds.min().y() * scale))));
        activeCategoryData.setScale(scale);
    }

    private void drawIcon(PoseStack matrices, TextureBatchedRenderer textureRenderer, ItemBatchedRenderer itemRenderer, ClientIconConfig icon, float sizeScale, int x, int y) {
        if (this.f_96541_ == null) {
            return;
        }
        matrices.m_85836_();
        if (icon instanceof ClientIconConfig.ItemIconConfig) {
            ClientIconConfig.ItemIconConfig itemIcon = (ClientIconConfig.ItemIconConfig)icon;
            matrices.m_252880_((float)x * (1.0f - sizeScale), (float)y * (1.0f - sizeScale), 1.0f);
            matrices.m_85841_(sizeScale, sizeScale, 1.0f);
            itemRenderer.emitItem(matrices, itemIcon.item(), x, y);
        } else if (icon instanceof ClientIconConfig.EffectIconConfig) {
            ClientIconConfig.EffectIconConfig effectIcon = (ClientIconConfig.EffectIconConfig)icon;
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            TextureAtlasSprite sprite = this.f_96541_.m_91306_().m_118732_(effectIcon.effect());
            int halfSize = Math.round(9.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitSpriteStretch(matrices, sprite, x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        } else if (icon instanceof ClientIconConfig.TextureIconConfig) {
            ClientIconConfig.TextureIconConfig textureIcon = (ClientIconConfig.TextureIconConfig)icon;
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            int halfSize = Math.round(8.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitTexture(matrices, textureIcon.texture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        }
        matrices.m_85849_();
    }

    private void drawFrame(PoseStack matrices, TextureBatchedRenderer textureRenderer, ClientFrameConfig frame, float sizeScale, int x, int y, Skill.State state) {
        if (this.f_96541_ == null) {
            return;
        }
        int halfSize = Math.round(13.0f * sizeScale);
        int size = halfSize * 2;
        if (frame instanceof ClientFrameConfig.AdvancementFrameConfig) {
            ClientFrameConfig.AdvancementFrameConfig advancementFrame = (ClientFrameConfig.AdvancementFrameConfig)frame;
            AdvancementWidgetType status = state == Skill.State.UNLOCKED ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            Vector4fc color = switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case Skill.State.LOCKED, Skill.State.EXCLUDED -> COLOR_GRAY;
                case Skill.State.AVAILABLE, Skill.State.AFFORDABLE, Skill.State.UNLOCKED -> COLOR_WHITE;
            };
            textureRenderer.emitTexture(matrices, WIDGETS_TEXTURE, x - halfSize, y - halfSize, size, size, (float)advancementFrame.frame().m_15551_() / 256.0f, (float)(128 + status.m_97325_() * 26) / 256.0f, (float)(advancementFrame.frame().m_15551_() + 26) / 256.0f, (float)(128 + status.m_97325_() * 26 + 26) / 256.0f, color);
        } else if (frame instanceof ClientFrameConfig.TextureFrameConfig) {
            ClientFrameConfig.TextureFrameConfig textureFrame = (ClientFrameConfig.TextureFrameConfig)frame;
            switch (state) {
                case LOCKED: {
                    textureFrame.lockedTexture().ifPresentOrElse(lockedTexture -> textureRenderer.emitTexture(matrices, (ResourceLocation)lockedTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(matrices, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY));
                    break;
                }
                case AVAILABLE: {
                    textureRenderer.emitTexture(matrices, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case AFFORDABLE: {
                    textureFrame.affordableTexture().ifPresentOrElse(affordableTexture -> textureRenderer.emitTexture(matrices, (ResourceLocation)affordableTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(matrices, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE));
                    break;
                }
                case UNLOCKED: {
                    textureRenderer.emitTexture(matrices, textureFrame.unlockedTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case EXCLUDED: {
                    textureFrame.excludedTexture().ifPresentOrElse(excludedTexture -> textureRenderer.emitTexture(matrices, (ResourceLocation)excludedTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(matrices, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private void drawBackground(PoseStack matrices, ClientBackgroundConfig background) {
        int y;
        int x;
        int height;
        int width;
        BackgroundPosition position = background.position();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background.texture());
        switch (position) {
            case TILE: {
                GuiComponent.m_93133_((PoseStack)matrices, (int)this.bounds.min().x(), (int)this.bounds.min().y(), (float)0.0f, (float)0.0f, (int)this.bounds.width(), (int)this.bounds.height(), (int)background.width(), (int)background.height());
                return;
            }
            case FILL: {
                if (this.bounds.width() * background.height() > background.width() * this.bounds.height()) {
                    position = BackgroundPosition.FILL_WIDTH;
                    break;
                }
                position = BackgroundPosition.FILL_HEIGHT;
                break;
            }
        }
        switch (position) {
            case NONE: {
                width = background.width();
                height = background.height();
                x = width / -2;
                y = height / -2;
                break;
            }
            case FILL_WIDTH: {
                x = this.bounds.min().x();
                width = this.bounds.width();
                y = this.bounds.min().y() + this.bounds.height() / 2 - Mth.m_184652_((int)(background.height() * width), (int)(2 * background.width()));
                height = Mth.m_184652_((int)(background.height() * width), (int)background.width());
                break;
            }
            case FILL_HEIGHT: {
                y = this.bounds.min().y();
                height = this.bounds.height();
                x = this.bounds.min().x() + this.bounds.width() / 2 - Mth.m_184652_((int)(background.width() * height), (int)(2 * background.height()));
                width = Mth.m_184652_((int)(background.width() * height), (int)background.height());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GuiComponent.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    private void drawContent(PoseStack matrices, double mouseX, double mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
        GuiComponent.m_239260_((int)(this.contentPaddingLeft - 4), (int)(this.contentPaddingTop - 4), (int)(this.f_96543_ - this.contentPaddingRight + 4), (int)(this.f_96544_ - this.contentPaddingBottom + 4));
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-16777216);
        this.optActiveCategoryData.ifPresentOrElse(activeCategoryData -> this.drawContentWithCategory(matrices, mouseX, mouseY, (ClientCategoryData)activeCategoryData), () -> this.drawContentWithoutCategory(matrices));
        GuiComponent.m_240060_();
    }

    private void drawContentWithCategory(PoseStack matrices, double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        if (this.f_96541_ == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY, activeCategoryData);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        matrices.m_85836_();
        matrices.m_252880_((float)activeCategoryData.getX() + (float)this.f_96543_ / 2.0f, (float)activeCategoryData.getY() + (float)this.f_96544_ / 2.0f, 0.0f);
        matrices.m_85841_(activeCategoryData.getScale(), activeCategoryData.getScale(), 1.0f);
        this.drawBackground(matrices, activeCategory.background());
        ConnectionBatchedRenderer connectionRenderer = new ConnectionBatchedRenderer();
        for (ClientSkillConnectionConfig connection : activeCategory.normalConnections()) {
            activeCategoryData.getConnection(connection).ifPresent(relation -> connectionRenderer.emitConnection(matrices, relation.getSkillA().x(), relation.getSkillA().y(), relation.getSkillB().x(), relation.getSkillB().y(), connection.bidirectional(), relation.getColor().fill().argb(), relation.getColor().stroke().argb()));
        }
        if (this.isInsideContent(mouse)) {
            Optional<ClientSkillConfig> optHoveredSkill = activeCategory.skills().values().stream().filter(skill -> activeCategory.getDefinitionById(skill.definitionId()).map(definition -> this.isInsideSkill(transformedMouse, (ClientSkillConfig)skill, (ClientSkillDefinitionConfig)definition)).orElse(false)).findFirst();
            optHoveredSkill.ifPresent(hoveredSkill -> {
                ClientSkillDefinitionConfig definition = activeCategory.definitions().get(hoveredSkill.definitionId());
                if (definition == null) {
                    return;
                }
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(definition.title().m_7532_());
                lines.addAll(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)ComponentUtils.m_130750_((MutableComponent)definition.description().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                if (Screen.m_96638_()) {
                    lines.addAll(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)ComponentUtils.m_130750_((MutableComponent)definition.extraDescription().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                }
                if (this.f_96541_.f_91066_.f_92125_) {
                    lines.add(Component.m_237113_((String)hoveredSkill.id()).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
                this.m_257959_(lines);
                Collection<ClientSkillConnectionConfig> connections = activeCategory.skillExclusiveConnections().get(hoveredSkill.id());
                if (connections != null) {
                    for (ClientSkillConnectionConfig connection : connections) {
                        activeCategoryData.getConnection(connection).ifPresent(relation -> connectionRenderer.emitConnection(matrices, relation.getSkillA().x(), relation.getSkillA().y(), relation.getSkillB().x(), relation.getSkillB().y(), connection.bidirectional(), relation.getColor().fill().argb(), relation.getColor().stroke().argb()));
                    }
                }
            });
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        connectionRenderer.draw();
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemRenderer = new ItemBatchedRenderer();
        for (ClientSkillConfig skill2 : activeCategory.skills().values()) {
            activeCategory.getDefinitionById(skill2.definitionId()).ifPresent(definition -> {
                this.drawFrame(matrices, textureRenderer, definition.frame(), definition.size(), skill2.x(), skill2.y(), activeCategoryData.getSkillState(skill2));
                this.drawIcon(matrices, textureRenderer, itemRenderer, definition.icon(), definition.size(), skill2.x(), skill2.y());
            });
        }
        textureRenderer.draw();
        itemRenderer.draw();
        matrices.m_85849_();
    }

    private void drawContentWithoutCategory(PoseStack matrices) {
        int tmpX = this.contentPaddingLeft + (this.f_96543_ - this.contentPaddingLeft - this.contentPaddingRight) / 2;
        MutableComponent mutableComponent = Component.m_237115_((String)"advancements.sad_label");
        Objects.requireNonNull(this.f_96547_);
        GuiComponent.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)mutableComponent, (int)tmpX, (int)(this.f_96544_ - this.contentPaddingBottom - 9), (int)-1);
        MutableComponent mutableComponent2 = Component.m_237115_((String)"advancements.empty");
        Objects.requireNonNull(this.f_96547_);
        GuiComponent.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)mutableComponent2, (int)tmpX, (int)(this.contentPaddingTop + (this.f_96544_ - this.contentPaddingTop - this.contentPaddingBottom - 9) / 2), (int)-1);
    }

    private void drawTabs(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.f_96541_ == null) {
            return;
        }
        if (this.hasNextButton()) {
            this.nextButton.m_86412_(matrices, mouseX, mouseY, delta);
        }
        if (this.hasPrevButton()) {
            this.prevButton.m_86412_(matrices, mouseX, mouseY, delta);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TABS_TEXTURE);
        this.forEachVisibleTab((x, category) -> GuiComponent.m_93133_((PoseStack)matrices, (int)x, (int)8, (float)(x == 8 ? 0.0f : 28.0f), (float)(this.optActiveCategoryData.orElse(null) == category ? 32.0f : 0.0f), (int)28, (int)32, (int)256, (int)256));
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemBatch = new ItemBatchedRenderer();
        this.forEachVisibleTab((x, category) -> {
            ClientCategoryConfig categoryConfig = category.getConfig();
            this.drawIcon(matrices, textureRenderer, itemBatch, categoryConfig.icon(), 1.0f, x + 6 + 8, 25);
            if (this.isInsideTab(mouse, (int)x)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(categoryConfig.title().m_7532_());
                lines.addAll(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)ComponentUtils.m_130750_((MutableComponent)categoryConfig.description().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                if (Screen.m_96638_()) {
                    lines.addAll(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)ComponentUtils.m_130750_((MutableComponent)categoryConfig.extraDescription().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                }
                if (this.f_96541_.f_91066_.f_92125_) {
                    lines.add(Component.m_237113_((String)categoryConfig.id().toString()).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
                this.m_257959_(lines);
            }
        });
        textureRenderer.draw();
        itemBatch.draw();
        this.forEachVisibleTab((x, category) -> {
            if (category.hasUnseenPoints()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TRIAL_ICON_TEXTURE);
                GuiComponent.m_93133_((PoseStack)matrices, (int)(x + 10), (int)3, (float)0.0f, (float)((float)(Util.m_137550_() / 800L & 1L) * 8.0f), (int)8, (int)8, (int)8, (int)16);
            }
        });
    }

    private void drawWindow(PoseStack matrices, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW_TEXTURE);
        GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)(this.f_96544_ - 8 - 70), (float)0.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126), (int)(this.f_96544_ - 8 - 70), (float)126.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        GuiComponent.m_93160_((PoseStack)matrices, (int)8, (int)78, (int)126, (int)(this.f_96544_ - 16 - 140), (float)0.0f, (float)69.0f, (int)126, (int)2, (int)256, (int)256);
        GuiComponent.m_93160_((PoseStack)matrices, (int)134, (int)(this.f_96544_ - 8 - 70), (int)(this.f_96543_ - 16 - 252), (int)70, (float)125.0f, (float)70.0f, (int)2, (int)70, (int)256, (int)256);
        GuiComponent.m_93160_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126), (int)78, (int)126, (int)(this.f_96544_ - 16 - 140), (float)126.0f, (float)69.0f, (int)126, (int)2, (int)256, (int)256);
        if (this.small) {
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)52, (float)0.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126), (int)52, (float)126.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            GuiComponent.m_93160_((PoseStack)matrices, (int)134, (int)36, (int)(this.f_96543_ - 16 - 252), (int)16, (float)125.0f, (float)0.0f, (int)2, (int)16, (int)256, (int)256);
            GuiComponent.m_93160_((PoseStack)matrices, (int)134, (int)52, (int)(this.f_96543_ - 16 - 252), (int)54, (float)125.0f, (float)8.0f, (int)2, (int)54, (int)256, (int)256);
        } else {
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            GuiComponent.m_93160_((PoseStack)matrices, (int)134, (int)36, (int)(this.f_96543_ - 16 - 252), (int)70, (float)125.0f, (float)0.0f, (int)2, (int)70, (int)256, (int)256);
        }
        MutableComponent tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)tmpX, (float)tmpY, -12566464);
        this.optActiveCategoryData.ifPresent(activeCategoryData -> this.drawWindowWithCategory(matrices, mouseX, mouseY, (ClientCategoryData)activeCategoryData));
    }

    private void drawWindowWithCategory(PoseStack matrices, double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        int tmpX = this.f_96543_ - 8 - 7;
        int tmpY = 42;
        int startX = tmpX;
        MutableComponent tmpText = Component.m_237113_((String)(activeCategoryData.getPointsLeft() + (String)(activeCategory.spentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategoryData.getSpentPointsLeft())));
        tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText);
        ClientFillStrokeColorsConfig pointsColor = activeCategory.colors().points();
        int pointsStrokeColor = pointsColor.stroke().argb();
        int pointsFillColor = pointsColor.fill().argb();
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)(--tmpX - 1), (float)tmpY, pointsStrokeColor);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)tmpX, (float)(tmpY - 1), pointsStrokeColor);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)(tmpX + 1), (float)tmpY, pointsStrokeColor);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)tmpX, (float)(tmpY + 1), pointsStrokeColor);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)tmpX, (float)tmpY, pointsFillColor);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)(tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText)), (float)tmpY, -12566464);
        Objects.requireNonNull(this.f_96547_);
        if (this.isInsideArea(mouse, tmpX, tmpY, startX, tmpY + 9)) {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            lines.add(SkillsMod.createTranslatable("tooltip", "earned_points", activeCategoryData.getEarnedPoints()).m_7532_());
            lines.add(SkillsMod.createTranslatable("tooltip", "spent_points", activeCategoryData.getSpentPoints() + (String)(activeCategory.spentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.spentPointsLimit())).m_7532_());
            this.m_257959_(lines);
        }
        if (activeCategoryData.hasExperience()) {
            if (this.small) {
                tmpX = this.f_96543_ - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (this.f_96543_ - 182) / 2;
                tmpY = 43;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
            SkillsScreen.m_93228_((PoseStack)matrices, (int)tmpX, (int)tmpY, (int)0, (int)64, (int)182, (int)5);
            int width = Math.min(182, (int)(activeCategoryData.getExperienceProgress() * 183.0f));
            if (width > 0) {
                SkillsScreen.m_93228_((PoseStack)matrices, (int)tmpX, (int)tmpY, (int)0, (int)69, (int)width, (int)5);
            }
            if (this.isInsideExperience(mouse, tmpX, tmpY)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(SkillsMod.createTranslatable("tooltip", "current_level", activeCategoryData.getCurrentLevel() + (String)(activeCategory.levelLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.levelLimit())).m_7532_());
                lines.add(SkillsMod.createTranslatable("tooltip", "experience_progress", activeCategoryData.getCurrentExperience(), activeCategoryData.getRequiredExperience(), Mth.m_14143_((float)(activeCategoryData.getExperienceProgress() * 100.0f))).m_7532_());
                lines.add(SkillsMod.createTranslatable("tooltip", "to_next_level", activeCategoryData.getExperienceToNextLevel()).m_7532_());
                this.m_257959_(lines);
            }
        }
    }
}

