/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.util.CommandUtils;

public class CategoryArgumentType
implements ArgumentType<class_2960> {
    private static final DynamicCommandExceptionType NO_SUCH_CATEGORY = new DynamicCommandExceptionType(id -> SkillsMod.createTranslatable("command", "no_such_category", id));
    private final boolean onlyWithExperience;

    public CategoryArgumentType(boolean onlyWithExperience) {
        this.onlyWithExperience = onlyWithExperience;
    }

    public static CategoryArgumentType category() {
        return new CategoryArgumentType(false);
    }

    public static CategoryArgumentType categoryOnlyWithExperience() {
        return new CategoryArgumentType(true);
    }

    public static Category getCategory(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2960 categoryId = SkillsMod.convertIdentifier((class_2960)context.getArgument(name, class_2960.class));
        return SkillsAPI.getCategory(categoryId).orElseThrow(() -> NO_SUCH_CATEGORY.create((Object)categoryId));
    }

    public static Category getCategoryOnlyWithExperience(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2960 categoryId = SkillsMod.convertIdentifier((class_2960)context.getArgument(name, class_2960.class));
        return SkillsAPI.getCategory(categoryId).filter(category -> category.getExperience().isPresent()).orElseThrow(() -> NO_SUCH_CATEGORY.create((Object)categoryId));
    }

    public class_2960 parse(StringReader reader) throws CommandSyntaxException {
        return class_2960.method_12835((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object source = context.getSource();
        if (source instanceof class_2168) {
            CommandUtils.suggestIdentifiers(SkillsMod.getInstance().getCategories(this.onlyWithExperience), builder);
            return builder.buildFuture();
        }
        if (source instanceof class_2172) {
            class_2172 commandSource = (class_2172)source;
            return commandSource.method_9261(context);
        }
        return Suggestions.empty();
    }

    public static class Serializer
    implements class_2314<CategoryArgumentType> {
        public void toPacket(CategoryArgumentType argumentType, class_2540 buf) {
            buf.writeBoolean(argumentType.onlyWithExperience);
        }

        public CategoryArgumentType fromPacket(class_2540 buf) {
            return new CategoryArgumentType(buf.readBoolean());
        }

        public void toJson(CategoryArgumentType argumentType, JsonObject jsonObject) {
            jsonObject.addProperty("only_with_experience", Boolean.valueOf(argumentType.onlyWithExperience));
        }
    }
}

