/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.common.BackgroundPosition;
import org.apache.commons.lang3.RandomStringUtils;

public record ClientBackgroundConfig(ResourceLocation texture, int width, int height, BackgroundPosition position) {
    public static ClientBackgroundConfig create(ResourceLocation textureId, int width, int height, BackgroundPosition position) {
        ResourceLocation id = SkillsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789"));
        ClientBackgroundTexture texture = new ClientBackgroundTexture(textureId);
        Minecraft.m_91087_().m_91097_().m_118495_(id, (AbstractTexture)texture);
        return new ClientBackgroundConfig(id, width, height, position);
    }

    private static class ClientBackgroundTexture
    extends AbstractTexture
    implements Tickable {
        private final ResourceLocation id;
        private TextureAtlasSprite sprite;

        public ClientBackgroundTexture(ResourceLocation id) {
            this.id = id;
        }

        public void m_6704_(ResourceManager manager) {
            this.sprite = manager.m_213713_(this.id).flatMap(resource -> {
                try {
                    AnimationMetadataSection metadata = resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
                    NativeImage image = NativeImage.m_85058_((InputStream)resource.m_215507_());
                    Pair size = metadata.m_7117_(image.m_84982_(), image.m_85084_());
                    TextureAtlasSprite.Info info = new TextureAtlasSprite.Info(this.id, ((Integer)size.getFirst()).intValue(), ((Integer)size.getSecond()).intValue(), metadata);
                    return Optional.of(new ClientBackgroundSprite(info, image.m_84982_(), image.m_85084_(), image));
                }
                catch (IOException ignored) {
                    return Optional.empty();
                }
            }).orElseGet(() -> MissingTextureAtlasSprite.m_118072_(null, (int)0, (int)16, (int)16, (int)0, (int)0));
            RenderSystem.m_69879_(() -> {
                this.m_117966_();
                TextureUtil.m_85287_((int)this.m_117963_(), (int)0, (int)this.sprite.m_118405_(), (int)this.sprite.m_118408_());
                this.sprite.m_118416_();
            });
        }

        public void m_7673_() {
            this.m_117966_();
            Tickable animation = this.sprite.m_174746_();
            if (animation != null) {
                animation.m_7673_();
            }
        }

        public void close() {
            this.sprite.close();
            super.close();
        }
    }

    private static class ClientBackgroundSprite
    extends TextureAtlasSprite {
        public ClientBackgroundSprite(TextureAtlasSprite.Info info, int width, int height, NativeImage image) {
            super(null, info, 0, width, height, 0, 0, image);
        }
    }
}

