/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class ConnectionBatchedRenderer {
    private final Int2ObjectMap<List<TriangleEmit>> strokeBatch = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<List<TriangleEmit>> fillBatch = new Int2ObjectOpenHashMap();

    public void emitConnection(PoseStack matrices, float startX, float startY, float endX, float endY, boolean bidirectional, int fillColor, int strokeColor) {
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        this.emitLine(this.strokeBatch, matrix, strokeColor, startX, startY, endX, endY, 3.0f);
        if (!bidirectional) {
            this.emitArrow(this.strokeBatch, matrix, strokeColor, startX, startY, endX, endY, 8.0f);
        }
        this.emitLine(this.fillBatch, matrix, fillColor, startX, startY, endX, endY, 1.0f);
        if (!bidirectional) {
            this.emitArrow(this.fillBatch, matrix, fillColor, startX, startY, endX, endY, 6.0f);
        }
    }

    private void emitLine(Int2ObjectMap<List<TriangleEmit>> batch, Matrix4f matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        Vec2 side = new Vec2(endX, endY).m_165910_(new Vec2(-startX, -startY)).m_165902_();
        side = new Vec2(side.f_82471_, -side.f_82470_).m_165903_(thickness / 2.0f);
        this.emitTriangle(batch, matrix, color, startX + side.f_82470_, startY + side.f_82471_, startX - side.f_82470_, startY - side.f_82471_, endX + side.f_82470_, endY + side.f_82471_);
        this.emitTriangle(batch, matrix, color, endX - side.f_82470_, endY - side.f_82471_, endX + side.f_82470_, endY + side.f_82471_, startX - side.f_82470_, startY - side.f_82471_);
    }

    private void emitArrow(Int2ObjectMap<List<TriangleEmit>> batch, Matrix4f matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        Vec2 center = new Vec2(endX, endY).m_165910_(new Vec2(startX, startY)).m_165903_(0.5f);
        Vec2 normal = new Vec2(endX, endY).m_165910_(new Vec2(-startX, -startY)).m_165902_();
        Vec2 forward = new Vec2(normal.f_82470_, normal.f_82471_).m_165903_(thickness);
        Vec2 backward = new Vec2(forward.f_82470_, forward.f_82471_).m_165903_(-0.5f);
        Vec2 back = new Vec2(center.f_82470_, center.f_82471_).m_165910_(backward);
        Vec2 side = new Vec2(backward.f_82471_, -backward.f_82470_).m_165903_(Mth.m_14116_((float)3.0f));
        this.emitTriangle(batch, matrix, color, center.f_82470_ + forward.f_82470_, center.f_82471_ + forward.f_82471_, back.f_82470_ - side.f_82470_, back.f_82471_ - side.f_82471_, back.f_82470_ + side.f_82470_, back.f_82471_ + side.f_82471_);
    }

    private void emitTriangle(Int2ObjectMap<List<TriangleEmit>> batch, Matrix4f matrix, int color, float x1, float y1, float x2, float y2, float x3, float y3) {
        Vector4f v1 = new Vector4f(x1, y1, 0.0f, 1.0f);
        Vector4f v2 = new Vector4f(x2, y2, 0.0f, 1.0f);
        Vector4f v3 = new Vector4f(x3, y3, 0.0f, 1.0f);
        v1.m_123607_(matrix);
        v2.m_123607_(matrix);
        v3.m_123607_(matrix);
        List emits = (List)batch.computeIfAbsent(color, key -> new ArrayList());
        emits.add(new TriangleEmit(v1.m_123601_(), v1.m_123615_(), v1.m_123616_(), v2.m_123601_(), v2.m_123615_(), v2.m_123616_(), v3.m_123601_(), v3.m_123615_(), v3.m_123616_()));
    }

    public void draw() {
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        this.drawBatch(this.strokeBatch);
        this.drawBatch(this.fillBatch);
    }

    private void drawBatch(Int2ObjectMap<List<TriangleEmit>> batch) {
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        for (Int2ObjectMap.Entry entry : batch.int2ObjectEntrySet()) {
            int color = entry.getIntKey();
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
            for (TriangleEmit emit : (List)entry.getValue()) {
                bufferBuilder.m_5483_((double)emit.x1, (double)emit.y1, (double)emit.z1).m_5752_();
                bufferBuilder.m_5483_((double)emit.x2, (double)emit.y2, (double)emit.z2).m_5752_();
                bufferBuilder.m_5483_((double)emit.x3, (double)emit.y3, (double)emit.z3).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        batch.clear();
    }

    private record TriangleEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
    }
}

