/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.LegacyCalculation;
import net.puffish.skillsmod.calculation.operation.LegacyOperationRegistry;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.DamageTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EntityTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ItemStackCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyEntityTypeTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyItemTagCondition;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerChunk;
import net.puffish.skillsmod.util.LegacyUtils;

public class KillEntityExperienceSource
implements ExperienceSource {
    private static final ResourceLocation ID = SkillsMod.createIdentifier("kill_entity");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);
    private final Calculation<Data> calculation;
    private final Optional<AntiFarmingPerChunk> optAntiFarming;

    private KillEntityExperienceSource(Calculation<Data> calculation, Optional<AntiFarmingPerChunk> optAntiFarming) {
        this.calculation = calculation;
        this.optAntiFarming = optAntiFarming;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, KillEntityExperienceSource::parse);
    }

    private static Result<KillEntityExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(rootObject -> KillEntityExperienceSource.parse(rootObject, context), context));
    }

    private static Result<KillEntityExperienceSource, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<Calculation<Data>> optCalculation = LegacyCalculation.parse(rootObject, PROTOTYPE, context).ifFailure(problems::add).getSuccess();
        Optional<AntiFarmingPerChunk> optAntiFarming = rootObject.get("anti_farming").getSuccess().flatMap(element -> AntiFarmingPerChunk.parse(element, context).ifFailure(problems::add).getSuccess().flatMap(Function.identity()));
        if (problems.isEmpty()) {
            return Result.success(new KillEntityExperienceSource(optCalculation.orElseThrow(), optAntiFarming));
        }
        return Result.failure(Problem.combine(problems));
    }

    public int getValue(ServerPlayer player, LivingEntity entity, ItemStack weapon, DamageSource damageSource, double entityDroppedXp) {
        return (int)Math.round(this.calculation.evaluate(new Data(player, entity, weapon, damageSource, entityDroppedXp)));
    }

    public Optional<AntiFarmingPerChunk> getAntiFarming() {
        return this.optAntiFarming;
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_weapon_item_stack"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::weapon));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_killed_living_entity"), BuiltinPrototypes.LIVING_ENTITY, OperationFactory.create(Data::entity));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_damage_source"), BuiltinPrototypes.DAMAGE_SOURCE, OperationFactory.create(Data::damageSource));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_dropped_experience"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::entityDroppedXp));
        LegacyOperationRegistry<Data> legacy = new LegacyOperationRegistry<Data>(PROTOTYPE);
        legacy.registerBooleanFunction("entity", EntityTypeCondition::parse, data -> data.entity().m_6095_());
        legacy.registerBooleanFunction("entity_tag", LegacyEntityTypeTagCondition::parse, data -> data.entity().m_6095_());
        legacy.registerBooleanFunction("weapon", ItemStackCondition::parse, Data::weapon);
        legacy.registerBooleanFunction("weapon_nbt", ItemStackCondition::parse, Data::weapon);
        legacy.registerBooleanFunction("weapon_tag", LegacyItemTagCondition::parse, Data::weapon);
        legacy.registerBooleanFunction("damage_type", DamageTypeCondition::parse, data -> data.damageSource().m_19385_());
        legacy.registerNumberFunction("player_effect", effect -> effect.m_19564_() + 1, EffectOperation::parse, Data::player);
        legacy.registerNumberFunction("player_attribute", AttributeInstance::m_22135_, AttributeOperation::parse, Data::player);
        legacy.registerNumberFunction("entity_dropped_experience", Data::entityDroppedXp);
        legacy.registerNumberFunction("entity_max_health", data -> data.entity().m_21233_());
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("player"), SkillsMod.createIdentifier("get_player"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("weapon_item_stack"), SkillsMod.createIdentifier("get_weapon_item_stack"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("killed_living_entity"), SkillsMod.createIdentifier("get_killed_living_entity"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("damage_source"), SkillsMod.createIdentifier("get_damage_source"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("dropped_experience"), SkillsMod.createIdentifier("get_dropped_experience"));
    }

    private record Data(ServerPlayer player, LivingEntity entity, ItemStack weapon, DamageSource damageSource, double entityDroppedXp) {
    }
}

