/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.json.JsonElementImpl;

public class JsonArrayImpl
implements net.puffish.skillsmod.api.json.JsonArray {
    private final JsonArray json;
    private final JsonPath path;

    public JsonArrayImpl(JsonArray json, JsonPath path) {
        this.json = json;
        this.path = path;
    }

    @Override
    public Stream<net.puffish.skillsmod.api.json.JsonElement> stream() {
        return Streams.mapWithIndex((Stream)Streams.stream((Iterator)this.json.iterator()), (jsonElement, i) -> new JsonElementImpl((JsonElement)jsonElement, this.path.getArray(i)));
    }

    @Override
    public <S, F> Result<List<S>, List<F>> getAsList(BiFunction<Integer, net.puffish.skillsmod.api.json.JsonElement, Result<S, F>> function) {
        ArrayList successes = new ArrayList();
        ArrayList failures = new ArrayList();
        for (int i = 0; i < this.json.size(); ++i) {
            function.apply(i, new JsonElementImpl(this.json.get(i), this.path.getArray(i))).ifSuccess(successes::add).ifFailure(failures::add);
        }
        if (failures.isEmpty()) {
            return Result.success(successes);
        }
        return Result.failure(failures);
    }

    @Override
    public int getSize() {
        return this.json.size();
    }

    @Override
    public JsonArray getJson() {
        return this.json;
    }

    @Override
    public JsonPath getPath() {
        return this.path;
    }
}

