/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class TextureBatchedRenderer {
    private final Map<ResourceLocation, List<TextureEmit>> batch = new HashMap<ResourceLocation, List<TextureEmit>>();

    public void emitTexture(PoseStack matrices, ResourceLocation texture, int x, int y, int width, int height, Vector4f color) {
        this.emitTextureBatched(matrices, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitTexture(PoseStack matrices, ResourceLocation texture, int x, int y, int width, int height, float minU, float minV, float maxU, float maxV, Vector4f color) {
        this.emitTextureBatched(matrices, texture, x, y, x + width, y + height, minU, minV, maxU, maxV, color);
    }

    public void emitSpriteStretch(PoseStack matrices, TextureAtlasSprite sprite, int x, int y, int width, int height, Vector4f color) {
        this.emitTextureBatched(matrices, sprite.m_118414_().m_118330_(), x, y, x + width, y + height, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), color);
    }

    private void emitTextureBatched(PoseStack matrices, ResourceLocation texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, Vector4f color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        Vector4f v1 = new Vector4f(minX, minY, 0.0f, 1.0f);
        Vector4f v2 = new Vector4f(minX, maxY, 0.0f, 1.0f);
        Vector4f v3 = new Vector4f(maxX, maxY, 0.0f, 1.0f);
        Vector4f v4 = new Vector4f(maxX, minY, 0.0f, 1.0f);
        v1.m_123607_(matrix);
        v2.m_123607_(matrix);
        v3.m_123607_(matrix);
        v4.m_123607_(matrix);
        emits.add(new TextureEmit(v1.m_123601_(), v1.m_123615_(), v1.m_123616_(), v2.m_123601_(), v2.m_123615_(), v2.m_123616_(), v3.m_123601_(), v3.m_123615_(), v3.m_123616_(), v4.m_123601_(), v4.m_123615_(), v4.m_123616_(), minU, minV, maxU, maxV, color));
    }

    public void draw() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        for (Map.Entry<ResourceLocation, List<TextureEmit>> entry : this.batch.entrySet()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)entry.getKey());
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            for (TextureEmit emit : entry.getValue()) {
                bufferBuilder.m_5483_((double)emit.x1, (double)emit.y1, (double)emit.z1).m_85950_(emit.color.m_123601_(), emit.color.m_123615_(), emit.color.m_123616_(), emit.color.m_123617_()).m_7421_(emit.minU, emit.minV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x2, (double)emit.y2, (double)emit.z2).m_85950_(emit.color.m_123601_(), emit.color.m_123615_(), emit.color.m_123616_(), emit.color.m_123617_()).m_7421_(emit.minU, emit.maxV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x3, (double)emit.y3, (double)emit.z3).m_85950_(emit.color.m_123601_(), emit.color.m_123615_(), emit.color.m_123616_(), emit.color.m_123617_()).m_7421_(emit.maxU, emit.maxV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x4, (double)emit.y4, (double)emit.z4).m_85950_(emit.color.m_123601_(), emit.color.m_123615_(), emit.color.m_123616_(), emit.color.m_123617_()).m_7421_(emit.maxU, emit.minV).m_5752_();
            }
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }
        this.batch.clear();
    }

    private record TextureEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, Vector4f color) {
    }
}

