/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public class AttributeReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("attribute");
    private final List<UUID> uuids = new ArrayList<UUID>();
    private final Attribute attribute;
    private final float value;
    private final AttributeModifier.Operation operation;

    private AttributeReward(Attribute attribute, float value, AttributeModifier.Operation operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, AttributeReward::parse);
    }

    private static Result<AttributeReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(AttributeReward::parse, context));
    }

    private static Result<AttributeReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optAttribute = rootObject.get("attribute").andThen(attributeElement -> BuiltinJson.parseAttribute(attributeElement).andThen(attribute -> {
            if (DefaultAttributes.m_22297_((EntityType)EntityType.f_20532_).m_22258_(attribute)) {
                return Result.success(attribute);
            }
            return Result.failure(attributeElement.getPath().createProblem("Expected a valid player attribute"));
        })).ifFailure(problems::add).getSuccess();
        Optional<Float> optValue = rootObject.getFloat("value").ifFailure(problems::add).getSuccess();
        Optional optOperation = rootObject.get("operation").andThen(BuiltinJson::parseAttributeOperation).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new AttributeReward((Attribute)optAttribute.orElseThrow(), optValue.orElseThrow().floatValue(), (AttributeModifier.Operation)optOperation.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    private void createMissingUUIDs(int count) {
        while (this.uuids.size() < count) {
            this.uuids.add(UUID.randomUUID());
        }
    }

    @Override
    public void update(RewardUpdateContext context) {
        int count = context.getCount();
        AttributeInstance instance = Objects.requireNonNull(context.getPlayer().m_21051_(this.attribute));
        this.createMissingUUIDs(count);
        for (int i = 0; i < this.uuids.size(); ++i) {
            UUID uuid = this.uuids.get(i);
            if (instance.m_22111_(uuid) == null) {
                if (i >= count) continue;
                instance.m_22118_(new AttributeModifier(uuid, "", (double)this.value, this.operation));
                continue;
            }
            if (i < count) continue;
            instance.m_22120_(uuid);
        }
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        for (ServerPlayer player : context.getServer().m_6846_().m_11314_()) {
            AttributeInstance instance = Objects.requireNonNull(player.m_21051_(this.attribute));
            for (UUID uuid : this.uuids) {
                instance.m_22120_(uuid);
            }
        }
        this.uuids.clear();
    }
}

