/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.util.LegacyUtils;

public class AttributeOperation
implements Operation<LivingEntity, AttributeInstance> {
    private final Attribute attribute;

    private AttributeOperation(Attribute attribute) {
        this.attribute = attribute;
    }

    public static void register() {
        BuiltinPrototypes.LIVING_ENTITY.registerOperation(SkillsMod.createIdentifier("get_attribute"), BuiltinPrototypes.ENTITY_ATTRIBUTE_INSTANCE, AttributeOperation::parse);
        LegacyBuiltinPrototypes.registerAlias(BuiltinPrototypes.LIVING_ENTITY, SkillsMod.createIdentifier("attribute"), SkillsMod.createIdentifier("get_attribute"));
    }

    public static Result<AttributeOperation, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(AttributeOperation::parse, context));
    }

    public static Result<AttributeOperation, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optAttribute = rootObject.get("attribute").andThen(BuiltinJson::parseAttribute).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new AttributeOperation((Attribute)optAttribute.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<AttributeInstance> apply(LivingEntity entity) {
        return Optional.ofNullable(entity.m_21051_(this.attribute));
    }
}

