/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public class StatValueOperation
implements Operation<ServerPlayer, Double> {
    private final Stat<?> stat;

    private StatValueOperation(Stat<?> stat) {
        this.stat = stat;
    }

    public static void register() {
        BuiltinPrototypes.PLAYER.registerOperation(SkillsMod.createIdentifier("get_stat_value"), BuiltinPrototypes.NUMBER, StatValueOperation::parse);
    }

    public static Result<StatValueOperation, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(StatValueOperation::parse, context));
    }

    public static Result<StatValueOperation, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optStat = rootObject.get("stat").andThen(BuiltinJson::parseStat).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new StatValueOperation((Stat)optStat.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Double> apply(ServerPlayer player) {
        return Optional.of(Double.valueOf(player.m_8951_().m_13015_(this.stat)));
    }
}

