/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;

public class ClientCategoryData {
    private final ClientCategoryConfig config;
    private final Map<String, Skill.State> skillStates;
    private final Map<ClientSkillConnectionConfig, ClientSkillConnectionData> connectionStates;
    private int spentPoints;
    private int earnedPoints;
    private int currentLevel;
    private int currentExperience;
    private int requiredExperience;
    private float scale = 1.0f;
    private int x = 0;
    private int y = 0;
    private long lastOpen;
    private static final int[][][] ORDER = new int[][][]{new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 2, 3, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 1, 0}, {0, 0, 0, 2, 0}, {0, 1, 2, 3, 0}, {0, 0, 0, 0, 0}}};

    public ClientCategoryData(ClientCategoryConfig config, Map<String, Skill.State> skillStates, int spentPoints, int earnedPoints, int currentLevel, int currentExperience, int requiredExperience) {
        ClientSkillConfig skillB;
        ClientSkillConfig skillA;
        this.config = config;
        this.skillStates = skillStates;
        this.spentPoints = spentPoints;
        this.earnedPoints = earnedPoints;
        this.currentLevel = currentLevel;
        this.currentExperience = currentExperience;
        this.requiredExperience = requiredExperience;
        this.connectionStates = new HashMap<ClientSkillConnectionConfig, ClientSkillConnectionData>();
        for (ClientSkillConnectionConfig connection : config.normalConnections()) {
            skillA = config.skills().get(connection.skillAId());
            if (skillA == null || (skillB = config.skills().get(connection.skillBId())) == null) continue;
            this.connectionStates.put(connection, new ClientSkillConnectionData(skillA, skillB, this.getConnectionColor(skillA, skillB, connection.bidirectional())));
        }
        for (ClientSkillConnectionConfig connection : config.exclusiveConnections()) {
            skillA = config.skills().get(connection.skillAId());
            if (skillA == null || (skillB = config.skills().get(connection.skillBId())) == null) continue;
            this.connectionStates.put(connection, new ClientSkillConnectionData(skillA, skillB, this.config.colors().connections().excluded()));
        }
    }

    private void updateSkillState(ClientSkillConfig skill, Skill.State state) {
        this.skillStates.put(skill.id(), state);
        Collection<ClientSkillConnectionConfig> normalConnections = this.config.skillNormalConnections().get(skill.id());
        if (normalConnections != null) {
            for (ClientSkillConnectionConfig connection : normalConnections) {
                this.updateConnection(connection);
            }
        }
    }

    public Skill.State getSkillState(ClientSkillConfig skill) {
        return this.skillStates.get(skill.id());
    }

    public void unlock(String skillId) {
        Collection<String> exclusiveNeighborsIds;
        Collection<String> normalNeighborsIds;
        ClientSkillConfig skill = this.config.skills().get(skillId);
        if (skill == null) {
            return;
        }
        this.updateSkillState(skill, Skill.State.UNLOCKED);
        if (skill.isRoot() && this.config.exclusiveRoot()) {
            this.config.skills().values().stream().filter(ClientSkillConfig::isRoot).filter(other -> switch (this.getSkillState((ClientSkillConfig)other)) {
                case Skill.State.AVAILABLE, Skill.State.AFFORDABLE -> true;
                default -> false;
            }).forEach(other -> this.updateSkillState((ClientSkillConfig)other, Skill.State.LOCKED));
        }
        if ((normalNeighborsIds = this.config.skillNormalNeighbors().get(skillId)) != null) {
            normalNeighborsIds.stream().map(id -> this.config.skills().get(id)).filter(Objects::nonNull).filter(neighbor -> this.getSkillState((ClientSkillConfig)neighbor) == Skill.State.LOCKED).forEach(neighbor -> {
                if (this.isAvailable((ClientSkillConfig)neighbor)) {
                    if (this.isAffordable((ClientSkillConfig)neighbor)) {
                        this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.AFFORDABLE);
                    } else {
                        this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.AVAILABLE);
                    }
                }
            });
        }
        if ((exclusiveNeighborsIds = this.config.skillExclusiveNeighbors().get(skillId)) != null) {
            exclusiveNeighborsIds.stream().map(id -> this.config.skills().get(id)).filter(Objects::nonNull).filter(neighbor -> this.getSkillState((ClientSkillConfig)neighbor) != Skill.State.UNLOCKED).forEach(neighbor -> this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.EXCLUDED));
        }
    }

    public void lock(String skillId) {
        Collection<String> exclusiveNeighborsIds;
        Collection<String> normalNeighborsIds;
        ClientSkillConfig skill = this.config.skills().get(skillId);
        if (skill == null) {
            return;
        }
        if (this.isExcluded(skill)) {
            this.updateSkillState(skill, Skill.State.EXCLUDED);
        } else if (this.isAvailable(skill)) {
            if (this.isAffordable(skill)) {
                this.updateSkillState(skill, Skill.State.AFFORDABLE);
            } else {
                this.updateSkillState(skill, Skill.State.AVAILABLE);
            }
        } else {
            this.updateSkillState(skill, Skill.State.LOCKED);
        }
        if (skill.isRoot() && this.config.exclusiveRoot() && this.config.skills().values().stream().filter(ClientSkillConfig::isRoot).allMatch(other -> this.getSkillState((ClientSkillConfig)other) != Skill.State.UNLOCKED)) {
            this.config.skills().values().stream().filter(ClientSkillConfig::isRoot).filter(other -> this.getSkillState((ClientSkillConfig)other) == Skill.State.LOCKED).forEach(other -> {
                if (this.isAffordable((ClientSkillConfig)other)) {
                    this.updateSkillState((ClientSkillConfig)other, Skill.State.AFFORDABLE);
                } else {
                    this.updateSkillState((ClientSkillConfig)other, Skill.State.AVAILABLE);
                }
            });
        }
        if ((normalNeighborsIds = this.config.skillNormalNeighbors().get(skillId)) != null) {
            normalNeighborsIds.stream().map(id -> this.config.skills().get(id)).filter(Objects::nonNull).filter(neighbor -> switch (this.getSkillState((ClientSkillConfig)neighbor)) {
                case Skill.State.AVAILABLE, Skill.State.AFFORDABLE -> true;
                default -> false;
            }).forEach(neighbor -> {
                if (!this.isAvailable((ClientSkillConfig)neighbor)) {
                    this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.LOCKED);
                }
            });
        }
        if ((exclusiveNeighborsIds = this.config.skillExclusiveNeighbors().get(skillId)) != null) {
            exclusiveNeighborsIds.stream().map(id -> this.config.skills().get(id)).filter(Objects::nonNull).filter(neighbor -> this.getSkillState((ClientSkillConfig)neighbor) == Skill.State.EXCLUDED).forEach(neighbor -> {
                if (!this.isExcluded((ClientSkillConfig)neighbor)) {
                    if (this.isAvailable((ClientSkillConfig)neighbor)) {
                        if (this.isAffordable((ClientSkillConfig)neighbor)) {
                            this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.AFFORDABLE);
                        } else {
                            this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.AVAILABLE);
                        }
                    } else {
                        this.updateSkillState((ClientSkillConfig)neighbor, Skill.State.LOCKED);
                    }
                }
            });
        }
    }

    private boolean isExcluded(ClientSkillConfig skill) {
        Collection<String> exclusiveNeighborsReversedIds = this.config.skillExclusiveNeighborsReversed().get(skill.id());
        if (exclusiveNeighborsReversedIds == null) {
            return false;
        }
        return exclusiveNeighborsReversedIds.stream().map(id -> this.config.skills().get(id)).filter(Objects::nonNull).anyMatch(neighbor -> this.getSkillState((ClientSkillConfig)neighbor) == Skill.State.UNLOCKED);
    }

    private boolean isAvailable(ClientSkillConfig skill) {
        if (skill.isRoot()) {
            return !this.config.exclusiveRoot() || this.config.skills().values().stream().filter(ClientSkillConfig::isRoot).allMatch(other -> this.getSkillState((ClientSkillConfig)other) != Skill.State.UNLOCKED);
        }
        Collection<String> normalNeighborsReversedIds = this.config.skillNormalNeighborsReversed().get(skill.id());
        if (normalNeighborsReversedIds == null) {
            return false;
        }
        return this.config.getDefinitionById(skill.definitionId()).map(definition -> normalNeighborsReversedIds.stream().map(id -> this.config.skills().get(id)).filter(Objects::nonNull).filter(neighbor -> this.getSkillState((ClientSkillConfig)neighbor) == Skill.State.UNLOCKED).count() >= (long)definition.requiredSkills()).orElse(false);
    }

    private boolean isAffordable(ClientSkillConfig skill) {
        return this.config.getDefinitionById(skill.definitionId()).map(this::isAffordable).orElse(false);
    }

    private boolean isAffordable(ClientSkillDefinitionConfig definition) {
        return this.getPointsLeft() >= Math.max(definition.requiredPoints(), definition.cost()) && this.spentPoints >= definition.requiredSpentPoints();
    }

    public boolean hasAnySkillLeft() {
        return this.config.skills().values().stream().map(this::getSkillState).anyMatch(state -> state == Skill.State.AVAILABLE || state == Skill.State.AFFORDABLE);
    }

    public void updatePoints(int spentPoints, int earnedPoints) {
        this.spentPoints = spentPoints;
        this.earnedPoints = earnedPoints;
        this.config.skills().values().stream().filter(skill -> switch (this.getSkillState((ClientSkillConfig)skill)) {
            case Skill.State.AVAILABLE, Skill.State.AFFORDABLE -> true;
            default -> false;
        }).forEach(skill -> {
            if (this.isAffordable((ClientSkillConfig)skill)) {
                this.updateSkillState((ClientSkillConfig)skill, Skill.State.AFFORDABLE);
            } else {
                this.updateSkillState((ClientSkillConfig)skill, Skill.State.AVAILABLE);
            }
        });
    }

    private void updateConnection(ClientSkillConnectionConfig connection) {
        ClientSkillConnectionData data = this.connectionStates.get(connection);
        if (data == null) {
            return;
        }
        data.setColor(this.getConnectionColor(data.getSkillA(), data.getSkillB(), connection.bidirectional()));
    }

    private ClientFillStrokeColorsConfig getConnectionColor(ClientSkillConfig skillA, ClientSkillConfig skillB, boolean bidirectional) {
        return switch (ORDER[bidirectional ? 1 : 0][this.getSkillState(skillA).ordinal()][this.getSkillState(skillB).ordinal()]) {
            case 3 -> this.config.colors().connections().unlocked();
            case 2 -> this.config.colors().connections().affordable();
            case 1 -> this.config.colors().connections().available();
            default -> this.config.colors().connections().locked();
        };
    }

    public Optional<ClientSkillConnectionData> getConnection(ClientSkillConnectionConfig connection) {
        return Optional.ofNullable(this.connectionStates.get(connection));
    }

    public ClientCategoryConfig getConfig() {
        return this.config;
    }

    public int getPointsLeft() {
        return Math.max(Math.min(this.earnedPoints, this.config.spentPointsLimit()) - this.spentPoints, 0);
    }

    public int getSpentPoints() {
        return this.spentPoints;
    }

    public int getEarnedPoints() {
        return this.earnedPoints;
    }

    public int getSpentPointsLeft() {
        return Math.max(this.config.spentPointsLimit() - this.spentPoints, 0);
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public boolean hasExperience() {
        return this.currentLevel >= 0;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getCurrentExperience() {
        return this.currentExperience;
    }

    public void setCurrentExperience(int currentExperience) {
        this.currentExperience = currentExperience;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public void setRequiredExperience(int requiredExperience) {
        this.requiredExperience = requiredExperience;
    }

    public float getExperienceProgress() {
        return (float)this.currentExperience / (float)this.requiredExperience;
    }

    public int getExperienceToNextLevel() {
        return this.requiredExperience - this.currentExperience;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public long getLastOpen() {
        return this.lastOpen;
    }

    public void updateLastOpen() {
        this.lastOpen = System.currentTimeMillis();
    }
}

