/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.util.CommandUtils;
import net.puffish.skillsmod.util.PointSources;

public class PointsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"points").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"category", (ArgumentType)CategoryArgumentType.category()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PointsCommand::addTotal)).then(Commands.m_82129_((String)"source", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(PointsCommand::add))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"category", (ArgumentType)CategoryArgumentType.category()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PointsCommand::setTotal)).then(Commands.m_82129_((String)"source", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(PointsCommand::set))))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(PointsCommand::getTotal)).then(Commands.m_82129_((String)"source", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(PointsCommand::get)))));
    }

    private static int add(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        ResourceLocation source = ResourceLocationArgument.m_107011_(context, (String)"source");
        for (ServerPlayer player : players) {
            category.addPoints(player, source, count);
        }
        CommandUtils.sendSuccess(context, players, "points.add", count, category.getId());
        return players.size();
    }

    private static int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        ResourceLocation source = ResourceLocationArgument.m_107011_(context, (String)"source");
        for (ServerPlayer player : players) {
            category.setPoints(player, source, count);
        }
        CommandUtils.sendSuccess(context, players, "points.set", count, category.getId());
        return players.size();
    }

    private static int get(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        Category category = CategoryArgumentType.getCategory(context, "category");
        ResourceLocation source = ResourceLocationArgument.m_107011_(context, (String)"source");
        int count = category.getPoints(player, source);
        CommandUtils.sendSuccess(context, player, "points.get", count, category.getId());
        return count;
    }

    private static int addTotal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        for (ServerPlayer player : players) {
            category.addPoints(player, PointSources.COMMANDS, count);
        }
        CommandUtils.sendSuccess(context, players, "points.add", count, category.getId());
        return players.size();
    }

    private static int setTotal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        for (ServerPlayer player : players) {
            category.setPoints(player, PointSources.COMMANDS, count - category.getPointsTotal(player));
        }
        CommandUtils.sendSuccess(context, players, "points.set", count, category.getId());
        return players.size();
    }

    private static int getTotal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = category.getPointsTotal(player);
        CommandUtils.sendSuccess(context, player, "points.get", count, category.getId());
        return count;
    }
}

