/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.io.BufferedReader;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.util.PathUtils;

public class PackConfigReader
extends ConfigReader {
    private final ResourceManager resourceManager;
    private final String namespace;

    public PackConfigReader(ResourceManager resourceManager, String namespace) {
        this.resourceManager = resourceManager;
        this.namespace = namespace;
    }

    public Result<JsonElement, Problem> readResource(ResourceLocation id, Resource resource) {
        Result<JsonElement, Problem> result;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                result = JsonElement.parseReader(reader, JsonPath.create(id.toString()));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Result.failure(Problem.message("Failed to read resource `" + String.valueOf(id) + "`"));
                }
            }
            reader.close();
        }
        return result;
    }

    @Override
    public Result<JsonElement, Problem> read(Path path) {
        ResourceLocation id = ResourceLocation.m_214293_((String)this.namespace, (String)PathUtils.pathToString(Path.of("puffish_skills", new String[0]).resolve(path)));
        return this.resourceManager.m_213713_(id).map(resource -> this.readResource(id, (Resource)resource)).orElseGet(() -> Result.failure(Problem.message("Resource `" + String.valueOf(id) + "` does not exist")));
    }

    @Override
    public boolean exists(Path path) {
        ResourceLocation id = ResourceLocation.m_214293_((String)this.namespace, (String)PathUtils.pathToString(Path.of("puffish_skills", new String[0]).resolve(path)));
        return this.resourceManager.m_213713_(id).isPresent();
    }
}

