/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.util.PointSources;

public class CategoryData {
    private final Set<String> unlockedSkills;
    private final Map<ResourceLocation, Integer> points;
    private boolean unlocked;
    private int experience;

    private CategoryData(Set<String> unlockedSkills, Map<ResourceLocation, Integer> points, boolean unlocked, int experience) {
        this.unlockedSkills = unlockedSkills;
        this.points = points;
        this.unlocked = unlocked;
        this.experience = experience;
    }

    public static CategoryData create(GeneralConfig general) {
        HashMap<ResourceLocation, Integer> points = new HashMap<ResourceLocation, Integer>();
        points.put(PointSources.STARTING, general.getStartingPoints());
        return new CategoryData(new HashSet<String>(), points, general.isUnlockedByDefault(), 0);
    }

    public static CategoryData read(CompoundTag nbt) {
        boolean unlocked = nbt.m_128471_("unlocked");
        int experience = nbt.m_128451_("experience");
        HashSet<String> unlockedSkills = new HashSet<String>();
        ListTag unlockedNbt = nbt.m_128437_("unlocked_skills", 8);
        for (Tag elementNbt : unlockedNbt) {
            if (!(elementNbt instanceof StringTag)) continue;
            StringTag stringNbt = (StringTag)elementNbt;
            unlockedSkills.add(stringNbt.m_7916_());
        }
        HashMap<ResourceLocation, Integer> points = new HashMap<ResourceLocation, Integer>();
        Tag pointsNbt = nbt.m_128423_("points");
        if (pointsNbt instanceof IntTag) {
            IntTag pointsNbtInt = (IntTag)pointsNbt;
            points.put(PointSources.LEGACY, pointsNbtInt.m_7047_());
        } else if (pointsNbt instanceof CompoundTag) {
            CompoundTag pointsNbtCompound = (CompoundTag)pointsNbt;
            for (String key : pointsNbtCompound.m_128431_()) {
                points.put(new ResourceLocation(key), pointsNbtCompound.m_128451_(key));
            }
        }
        return new CategoryData(unlockedSkills, points, unlocked, experience);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.m_128379_("unlocked", this.unlocked);
        nbt.m_128405_("experience", this.experience);
        ListTag unlockedNbt = new ListTag();
        for (String skill : this.unlockedSkills) {
            unlockedNbt.add((Object)StringTag.m_129297_((String)skill));
        }
        nbt.m_128365_("unlocked_skills", (Tag)unlockedNbt);
        CompoundTag pointsNbt = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.points.entrySet()) {
            if (entry.getValue() == 0) continue;
            pointsNbt.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        nbt.m_128365_("points", (Tag)pointsNbt);
        return nbt;
    }

    public Skill.State getSkillState(CategoryConfig category, SkillConfig skill, SkillDefinitionConfig definition) {
        if (this.unlockedSkills.contains(skill.getId())) {
            return Skill.State.UNLOCKED;
        }
        if (category.getConnections().getExclusive().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().anyMatch(this.unlockedSkills::contains)).orElse(false).booleanValue()) {
            return Skill.State.EXCLUDED;
        }
        if (category.getConnections().getNormal().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().filter(this.unlockedSkills::contains).count()).orElse(0L) >= (long)definition.getRequiredSkills()) {
            return this.canAfford(category, definition) ? Skill.State.AFFORDABLE : Skill.State.AVAILABLE;
        }
        if (skill.isRoot()) {
            if (category.getGeneral().isExclusiveRoot() && this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).stream()).anyMatch(SkillConfig::isRoot)) {
                return Skill.State.LOCKED;
            }
            return this.canAfford(category, definition) ? Skill.State.AFFORDABLE : Skill.State.AVAILABLE;
        }
        return Skill.State.LOCKED;
    }

    private boolean canAfford(CategoryConfig category, SkillDefinitionConfig definition) {
        return this.getPointsLeft(category) >= Math.max(definition.getRequiredPoints(), definition.getCost()) && this.getSpentPoints(category) >= definition.getRequiredSpentPoints();
    }

    public boolean canUnlockSkill(CategoryConfig category, SkillConfig skill) {
        String definitionId = skill.getDefinitionId();
        return category.getDefinitions().getById(definitionId).map(definition -> this.getSkillState(category, skill, (SkillDefinitionConfig)definition) == Skill.State.AFFORDABLE).orElse(false);
    }

    public int countUnlocked(CategoryConfig category, String definitionId) {
        return category.getDefinitions().getById(definitionId).map(definition -> category.getSkills().getAll().stream().filter(skill -> skill.getDefinitionId().equals(definitionId)).filter(skill -> this.getSkillState(category, (SkillConfig)skill, (SkillDefinitionConfig)definition) == Skill.State.UNLOCKED).count()).orElse(0L).intValue();
    }

    public void unlockSkill(String id) {
        this.unlockedSkills.add(id);
    }

    public void lockSkill(String id) {
        this.unlockedSkills.remove(id);
    }

    public void resetSkills() {
        this.unlockedSkills.clear();
    }

    public Set<String> getUnlockedSkillIds() {
        return this.unlockedSkills;
    }

    public void addExperience(int experience) {
        this.experience += experience;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int earnedExperience) {
        this.experience = earnedExperience;
    }

    public int getSpentPoints(CategoryConfig category) {
        return this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).flatMap(skill -> category.getDefinitions().getById(skill.getDefinitionId())).stream()).mapToInt(SkillDefinitionConfig::getCost).sum();
    }

    public int getPointsTotal() {
        int total = 0;
        for (Integer count : this.points.values()) {
            total += count.intValue();
        }
        return total;
    }

    public int getPointsLeft(CategoryConfig category) {
        return Math.min(this.getPointsTotal(), category.getGeneral().getSpentPointsLimit()) - this.getSpentPoints(category);
    }

    public void addPoints(ResourceLocation source, int count) {
        this.points.compute(source, (key, value) -> (value == null ? 0 : value) + count);
    }

    public int getPoints(ResourceLocation source) {
        return this.points.getOrDefault(source, 0);
    }

    public void setPoints(ResourceLocation source, int points) {
        this.points.put(source, points);
    }

    public Stream<ResourceLocation> getPointsSources() {
        return this.points.entrySet().stream().filter(e -> (Integer)e.getValue() != 0).map(Map.Entry::getKey);
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void unlock() {
        this.unlocked = true;
    }

    public void lock() {
        this.unlocked = false;
    }
}

