/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.Config;
import net.puffish.skillsmod.util.LegacyUtils;

public record ModConfig(int version, boolean showWarnings, List<String> categories) implements Config
{
    public static Result<ModConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnusedConfig(rootObject -> ModConfig.parse(rootObject, context), context));
    }

    private static Result<ModConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<Integer> optVersion = rootObject.getInt("version").ifFailure(problems::add).getSuccess();
        Boolean showWarnings = rootObject.get("show_warnings").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(false);
        List categories = rootObject.get("categories").getSuccess().flatMap(categoriesElement -> categoriesElement.getAsArray().andThen(array -> array.getAsList((i, element) -> BuiltinJson.parseIdentifierPath(element)).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        if (problems.isEmpty()) {
            int version = optVersion.orElseThrow();
            if (version < 1) {
                return Result.failure(Problem.message("Configuration is outdated. Check out the mod's wiki to learn how to update the configuration."));
            }
            if (version > 3) {
                return Result.failure(Problem.message("Configuration is for a newer version of the mod. Please update the mod."));
            }
            if (version < 3) {
                context.emitWarning(rootObject.getPath().getObject("version").createProblem("Configuration uses outdated version. Please update the configuration version to 3").toString());
            }
            return Result.success(new ModConfig(version, showWarnings, categories));
        }
        return Result.failure(Problem.combine(problems));
    }
}

