/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;

public class JsonPathImpl
implements JsonPath {
    private final List<String> path;

    public JsonPathImpl(List<String> path) {
        this.path = path;
    }

    @Override
    public JsonPath getArray(long index) {
        return this.get("index " + index);
    }

    @Override
    public JsonPath getObject(String key) {
        return this.get("`" + key + "`");
    }

    private JsonPath get(String str) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(str);
        path.addAll(this.path);
        return new JsonPathImpl(path);
    }

    @Override
    public Optional<JsonPath> getParent() {
        if (this.path.size() <= 1) {
            return Optional.empty();
        }
        return Optional.of(new JsonPathImpl(new ArrayList<String>(this.path.subList(1, this.path.size()))));
    }

    public String getHead() {
        return this.path.get(0);
    }

    public Problem expectedToExist() {
        return this.expectedTo("exist");
    }

    public Problem expectedToExistAndBe(String str) {
        return this.expectedTo("exist and be " + str);
    }

    public Problem expectedToBe(String str) {
        return this.expectedTo("be " + str);
    }

    @Override
    public Problem createProblem(String message) {
        return Problem.message(message + " at " + String.valueOf(this));
    }

    public Problem expectedTo(String str) {
        Optional<JsonPath> parent = this.getParent();
        if (parent.isPresent()) {
            return Problem.message("Expected " + this.getHead() + " to " + str + " at " + String.valueOf(parent.orElseThrow()) + ".");
        }
        return Problem.message("Expected " + this.getHead() + " to " + str + ".");
    }

    @Override
    public String toString() {
        return String.join((CharSequence)" at ", this.path);
    }
}

