/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.network.packets.out;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.common.FrameType;
import net.puffish.skillsmod.common.IconType;
import net.puffish.skillsmod.common.SkillConnection;
import net.puffish.skillsmod.config.BackgroundConfig;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.FrameConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.colors.ColorConfig;
import net.puffish.skillsmod.config.colors.ColorsConfig;
import net.puffish.skillsmod.config.colors.ConnectionsColorsConfig;
import net.puffish.skillsmod.config.colors.FillStrokeColorsConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.experience.ExperienceCurve;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.server.data.CategoryData;

public record ShowCategoryOutPacket(CategoryConfig category, CategoryData categoryData) implements OutPacket
{
    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.category.id());
        this.write(buf, this.category.general());
        this.write(buf, this.category.definitions());
        this.write((FriendlyByteBuf)buf, this.category.skills());
        this.write((FriendlyByteBuf)buf, this.category.connections());
        buf.writeMap(this.category.skills().getMap(), FriendlyByteBuf::writeUtf, (buf1, skill) -> buf1.writeEnum((Enum)this.categoryData.getSkillState(this.category, (SkillConfig)skill, this.category.definitions().getById(skill.definitionId()).orElseThrow())));
        buf.writeInt(this.categoryData.getSpentPoints(this.category));
        buf.writeInt(this.categoryData.getPointsTotal());
        this.category.experience().ifPresentOrElse(experience -> {
            buf.writeBoolean(true);
            ExperienceCurve curve = experience.curve();
            buf.writeInt(curve.getLevelLimit());
            ExperienceCurve.Progress progress = curve.getProgress(this.categoryData.getExperience());
            buf.writeInt(progress.currentLevel());
            buf.writeInt(progress.currentExperience());
            buf.writeInt(progress.requiredExperience());
        }, () -> buf.writeBoolean(false));
    }

    public void write(RegistryFriendlyByteBuf buf, SkillDefinitionsConfig definitions) {
        buf.writeCollection(definitions.getAll(), (buf1, definition) -> this.write(buf, (SkillDefinitionConfig)definition));
    }

    public void write(RegistryFriendlyByteBuf buf, GeneralConfig general) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)general.title());
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)general.description());
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)general.extraDescription());
        ShowCategoryOutPacket.write(buf, general.icon());
        ShowCategoryOutPacket.write((FriendlyByteBuf)buf, general.background());
        ShowCategoryOutPacket.write((FriendlyByteBuf)buf, general.colors());
        buf.writeBoolean(general.exclusiveRoot());
        buf.writeInt(general.spentPointsLimit());
    }

    public void write(RegistryFriendlyByteBuf buf, SkillDefinitionConfig definition) {
        buf.writeUtf(definition.id());
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)definition.title());
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)definition.description());
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)definition.extraDescription());
        ShowCategoryOutPacket.write((FriendlyByteBuf)buf, definition.frame());
        ShowCategoryOutPacket.write(buf, definition.icon());
        buf.writeFloat(definition.size());
        buf.writeInt(definition.cost());
        buf.writeInt(definition.requiredSkills());
        buf.writeInt(definition.requiredPoints());
        buf.writeInt(definition.requiredSpentPoints());
        buf.writeInt(definition.requiredExclusions());
    }

    public void write(FriendlyByteBuf buf, SkillsConfig skills) {
        buf.writeCollection(skills.getAll(), ShowCategoryOutPacket::write);
    }

    public void write(FriendlyByteBuf buf, SkillConnectionsConfig connections) {
        buf.writeCollection(connections.normal().getAll(), ShowCategoryOutPacket::write);
        buf.writeCollection(connections.exclusive().getAll(), ShowCategoryOutPacket::write);
    }

    public static void write(FriendlyByteBuf buf, SkillConfig skill) {
        buf.writeUtf(skill.id());
        buf.writeInt(skill.x());
        buf.writeInt(skill.y());
        buf.writeUtf(skill.definitionId());
        buf.writeBoolean(skill.isRoot());
    }

    public static void write(FriendlyByteBuf buf, SkillConnection skill) {
        buf.writeUtf(skill.skillAId());
        buf.writeUtf(skill.skillBId());
        buf.writeBoolean(skill.bidirectional());
    }

    public static void write(RegistryFriendlyByteBuf buf, IconConfig icon) {
        if (icon instanceof IconConfig.EffectIconConfig) {
            IconConfig.EffectIconConfig effectIcon = (IconConfig.EffectIconConfig)icon;
            buf.writeEnum((Enum)IconType.EFFECT);
            buf.writeResourceLocation(BuiltInRegistries.MOB_EFFECT.getKey((Object)effectIcon.effect()));
        } else if (icon instanceof IconConfig.ItemIconConfig) {
            IconConfig.ItemIconConfig itemIcon = (IconConfig.ItemIconConfig)icon;
            buf.writeEnum((Enum)IconType.ITEM);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)itemIcon.item());
        } else if (icon instanceof IconConfig.TextureIconConfig) {
            IconConfig.TextureIconConfig textureIcon = (IconConfig.TextureIconConfig)icon;
            buf.writeEnum((Enum)IconType.TEXTURE);
            buf.writeResourceLocation(textureIcon.texture());
        }
    }

    public static void write(FriendlyByteBuf buf, FrameConfig frame) {
        if (frame instanceof FrameConfig.AdvancementFrameConfig) {
            FrameConfig.AdvancementFrameConfig advancementFrame = (FrameConfig.AdvancementFrameConfig)frame;
            buf.writeEnum((Enum)FrameType.ADVANCEMENT);
            buf.writeEnum((Enum)advancementFrame.frame());
        } else if (frame instanceof FrameConfig.TextureFrameConfig) {
            FrameConfig.TextureFrameConfig textureFrame = (FrameConfig.TextureFrameConfig)frame;
            buf.writeEnum((Enum)FrameType.TEXTURE);
            buf.writeOptional(textureFrame.lockedTexture(), FriendlyByteBuf::writeResourceLocation);
            buf.writeResourceLocation(textureFrame.availableTexture());
            buf.writeOptional(textureFrame.affordableTexture(), FriendlyByteBuf::writeResourceLocation);
            buf.writeResourceLocation(textureFrame.unlockedTexture());
            buf.writeOptional(textureFrame.excludedTexture(), FriendlyByteBuf::writeResourceLocation);
        }
    }

    public static void write(FriendlyByteBuf buf, BackgroundConfig background) {
        buf.writeResourceLocation(background.texture());
        buf.writeInt(background.width());
        buf.writeInt(background.height());
        buf.writeEnum((Enum)background.position());
    }

    public static void write(FriendlyByteBuf buf, ColorsConfig colors) {
        ShowCategoryOutPacket.write(buf, colors.connections());
        ShowCategoryOutPacket.write(buf, colors.points());
    }

    public static void write(FriendlyByteBuf buf, ConnectionsColorsConfig connectionsColors) {
        ShowCategoryOutPacket.write(buf, connectionsColors.locked());
        ShowCategoryOutPacket.write(buf, connectionsColors.available());
        ShowCategoryOutPacket.write(buf, connectionsColors.affordable());
        ShowCategoryOutPacket.write(buf, connectionsColors.unlocked());
        ShowCategoryOutPacket.write(buf, connectionsColors.excluded());
    }

    public static void write(FriendlyByteBuf buf, FillStrokeColorsConfig fillStrokeColors) {
        ShowCategoryOutPacket.write(buf, fillStrokeColors.fill());
        ShowCategoryOutPacket.write(buf, fillStrokeColors.stroke());
    }

    public static void write(FriendlyByteBuf buf, ColorConfig color) {
        buf.writeInt(color.argb());
    }

    @Override
    public ResourceLocation getId() {
        return Packets.SHOW_CATEGORY;
    }
}

