/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.calculation.operation;

import java.util.Optional;
import java.util.function.Function;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public interface OperationFactory<T, R> {
    default public <V> OperationFactory<T, V> andThen(Function<? super R, ? extends V> after) {
        return context -> this.apply(context).mapSuccess(o -> v -> ((Optional)o.apply(v)).map(after));
    }

    default public <V> OperationFactory<V, R> compose(Function<? super V, ? extends T> before) {
        return context -> this.apply(context).mapSuccess(o -> v -> (Optional)o.apply(before.apply((Object)v)));
    }

    default public OperationFactory<Optional<T>, R> optional() {
        return context -> this.apply(context).mapSuccess(o -> t -> t.flatMap(o));
    }

    public static <T, R> OperationFactory<T, R> create(Function<T, R> function) {
        return context -> Result.success(t -> Optional.of(function.apply(t)));
    }

    public static <T, R> OperationFactory<T, R> createOptional(Operation<T, R> operation) {
        return context -> Result.success(operation);
    }

    public Result<? extends Operation<T, R>, Problem> apply(OperationConfigContext var1);
}

