/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.FrameConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.util.DisposeContext;
import net.puffish.skillsmod.util.LegacyUtils;

public record SkillDefinitionConfig(String id, class_2561 title, class_2561 description, class_2561 extraDescription, IconConfig icon, FrameConfig frame, float size, List<SkillRewardConfig> rewards, int cost, int requiredSkills, int requiredPoints, int requiredSpentPoints, int requiredExclusions) {
    public static Result<Optional<SkillDefinitionConfig>, Problem> parse(String id, JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> SkillDefinitionConfig.parse(id, rootObject, context), context));
    }

    public static Result<Optional<SkillDefinitionConfig>, Problem> parse(String id, JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optTitle = rootObject.get("title").andThen(BuiltinJson::parseText).ifFailure(problems::add).getSuccess();
        class_2561 description = rootObject.get("description").getSuccess().flatMap(descriptionElement -> BuiltinJson.parseText(descriptionElement).ifFailure(problems::add).getSuccess()).orElseGet(class_2561::method_43473);
        class_2561 extraDescription = rootObject.get("extra_description").getSuccess().flatMap(descriptionElement -> BuiltinJson.parseText(descriptionElement).ifFailure(problems::add).getSuccess()).orElseGet(class_2561::method_43473);
        Optional optIcon = rootObject.get("icon").andThen(element -> IconConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        FrameConfig frame = rootObject.get("frame").getSuccess().flatMap(element -> FrameConfig.parse(element, context).ifFailure(problems::add).getSuccess()).orElseGet(FrameConfig::createDefault);
        Float size = rootObject.get("size").getSuccess().flatMap(element -> element.getAsFloat().ifFailure(problems::add).getSuccess()).orElse(Float.valueOf(1.0f));
        List rewards = rootObject.getArray("rewards").getSuccess().flatMap(array -> array.getAsList((i, element) -> SkillRewardConfig.parse(element, context)).mapFailure(Problem::combine).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        Integer cost = rootObject.get("cost").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(1);
        Integer requiredSkills = rootObject.get("required_skills").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(1);
        Integer requiredPoints = rootObject.get("required_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Integer requiredSpentPoints = rootObject.get("required_spent_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Integer requiredExclusions = rootObject.get("required_exclusions").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(1);
        List requiredMods = rootObject.get("required_mods").getSuccess().flatMap(element -> element.getAsArray().andThen(array -> array.getAsList((i, e) -> e.getAsString()).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        rootObject.get("metadata");
        if (!requiredMods.stream().allMatch(SkillsMod.getInstance().getPlatform()::isModLoaded)) {
            return Result.success(Optional.empty());
        }
        if (problems.isEmpty()) {
            return Result.success(Optional.of(new SkillDefinitionConfig(id, (class_2561)optTitle.orElseThrow(), description, extraDescription, (IconConfig)optIcon.orElseThrow(), frame, size.floatValue(), rewards, cost, requiredSkills, requiredPoints, requiredSpentPoints, requiredExclusions)));
        }
        return Result.failure(Problem.combine(problems));
    }

    public void dispose(DisposeContext context) {
        for (SkillRewardConfig reward : this.rewards) {
            reward.dispose(context);
        }
    }
}

