/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.source.builtin.DealDamageExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.HealExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.SharedKillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerChunk;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerEntity;
import net.puffish.skillsmod.util.AttackerInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;
    @Unique
    private final Map<class_3222, Float> damageShare = new WeakHashMap<class_3222, Float>();
    @Unique
    private final AntiFarmingPerEntity.State antiFarmingPerEntityState = new AntiFarmingPerEntity.State();

    @Inject(method={"heal"}, at={@At(value="TAIL")})
    private void injectAtHeal(float amount, CallbackInfo ci) {
        class_1309 class_13092;
        if (amount > 0.0f && (class_13092 = (class_1309)this) instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            SkillsAPI.updateExperienceSources(player, HealExperienceSource.class, es -> (int)Math.round(es.calculation().evaluate(new HealExperienceSource.Data(player, amount))));
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void injectAtApplyDamage(class_1282 source, float damage, CallbackInfo ci) {
        AttackerInfo.detect(source.method_5529(), attackerInfo -> {
            class_1309 entity = (class_1309)this;
            class_1799 weapon = ((DamageSourceAccess)source).getWeapon().orElse(class_1799.field_8037);
            class_3222 player = attackerInfo.player();
            AntiFarmingPerChunk.State antiFarmingPerChunkState = ((WorldChunkAccess)entity.method_37908().method_8500(entity.method_24515())).getAntiFarmingPerChunkState();
            antiFarmingPerChunkState.removeOutdated();
            this.damageShare.compute(player, (key, value) -> {
                if (value == null) {
                    return Float.valueOf(damage);
                }
                return Float.valueOf(value.floatValue() + damage);
            });
            this.antiFarmingPerEntityState.removeOutdated();
            SkillsAPI.updateExperienceSources(player, DealDamageExperienceSource.class, es -> {
                if (attackerInfo.matchesTamedActivity(es.tamedActivity())) {
                    float limitedDamage;
                    if (es.antiFarmingPerChunk().map(antiFarmingPerChunkState::tryIncrement).orElse(true).booleanValue() && (limitedDamage = es.antiFarmingPerEntity().map(antiFarming -> Float.valueOf(this.antiFarmingPerEntityState.addAndLimit((AntiFarmingPerEntity)antiFarming, damage))).orElse(Float.valueOf(damage)).floatValue()) > 1.0E-5f) {
                        return (int)Math.round(es.calculation().evaluate(new DealDamageExperienceSource.Data(player, entity, weapon, limitedDamage, source)));
                    }
                }
                return 0;
            });
        });
    }

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    private void injectAtDrop(class_1282 source, CallbackInfo ci) {
        AttackerInfo.detect(source.method_5529(), attackerInfo -> {
            class_1309 entity = (class_1309)this;
            class_1799 weapon = ((DamageSourceAccess)source).getWeapon().orElse(class_1799.field_8037);
            class_3222 player = attackerInfo.player();
            AntiFarmingPerChunk.State antiFarmingPerChunkState = ((WorldChunkAccess)entity.method_37908().method_8500(entity.method_24515())).getAntiFarmingPerChunkState();
            antiFarmingPerChunkState.removeOutdated();
            SkillsAPI.updateExperienceSources(player, KillEntityExperienceSource.class, es -> {
                if (attackerInfo.matchesTamedActivity(es.tamedActivity())) {
                    if (es.antiFarmingPerChunk().map(antiFarmingPerChunkState::tryIncrement).orElse(true).booleanValue()) {
                        return (int)Math.round(es.calculation().evaluate(new KillEntityExperienceSource.Data(player, entity, weapon, source, this.entityDroppedXp)));
                    }
                }
                return 0;
            });
            Set<Map.Entry<class_3222, Float>> entries = this.damageShare.entrySet();
            double totalDamage = entries.stream().mapToDouble(Map.Entry::getValue).sum();
            for (Map.Entry<class_3222, Float> entry : entries) {
                SkillsAPI.updateExperienceSources(entry.getKey(), SharedKillEntityExperienceSource.class, es -> {
                    if (attackerInfo.matchesTamedActivity(es.tamedActivity())) {
                        if (es.antiFarmingPerChunk().map(antiFarmingPerChunkState::tryIncrement).orElse(true).booleanValue()) {
                            return (int)Math.round(es.calculation().evaluate(new SharedKillEntityExperienceSource.Data((class_3222)entry.getKey(), entity, weapon, source, this.entityDroppedXp, totalDamage, entries.size(), (double)((Float)entry.getValue()).floatValue() / totalDamage)));
                        }
                    }
                    return 0;
                });
            }
        });
    }

    @ModifyArg(method={"dropXp"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    private int injectAtDropXp(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }
}

