/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.FrameConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.util.DisposeContext;
import net.puffish.skillsmod.util.LegacyUtils;

public class SkillDefinitionConfig {
    private final String id;
    private final Component title;
    private final Component description;
    private final Component extraDescription;
    private final IconConfig icon;
    private final FrameConfig frame;
    private final float size;
    private final List<SkillRewardConfig> rewards;
    private final int cost;
    private final int requiredSkills;
    private final int requiredPoints;
    private final int requiredSpentPoints;
    private final int requiredExclusions;

    private SkillDefinitionConfig(String id, Component title, Component description, Component extraDescription, IconConfig icon, FrameConfig frame, float size, List<SkillRewardConfig> rewards, int cost, int requiredSkills, int requiredPoints, int requiredSpentPoints, int requiredExclusions) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.extraDescription = extraDescription;
        this.icon = icon;
        this.frame = frame;
        this.size = size;
        this.rewards = rewards;
        this.cost = cost;
        this.requiredSkills = requiredSkills;
        this.requiredPoints = requiredPoints;
        this.requiredSpentPoints = requiredSpentPoints;
        this.requiredExclusions = requiredExclusions;
    }

    public static Result<SkillDefinitionConfig, Problem> parse(String id, JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> SkillDefinitionConfig.parse(id, rootObject, context), context));
    }

    public static Result<SkillDefinitionConfig, Problem> parse(String id, JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optTitle = rootObject.get("title").andThen(titleElement -> BuiltinJson.parseText(titleElement, (RegistryAccess)context.getServer().registryAccess())).ifFailure(problems::add).getSuccess();
        Component description = rootObject.get("description").getSuccess().flatMap(descriptionElement -> BuiltinJson.parseText(descriptionElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess()).orElseGet(Component::empty);
        Component extraDescription = rootObject.get("extra_description").getSuccess().flatMap(descriptionElement -> BuiltinJson.parseText(descriptionElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess()).orElseGet(Component::empty);
        Optional optIcon = rootObject.get("icon").andThen(element -> IconConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        FrameConfig frame = rootObject.get("frame").getSuccess().flatMap(element -> FrameConfig.parse(element, context).ifFailure(problems::add).getSuccess()).orElseGet(FrameConfig::createDefault);
        Float size = rootObject.get("size").getSuccess().flatMap(element -> element.getAsFloat().ifFailure(problems::add).getSuccess()).orElse(Float.valueOf(1.0f));
        List rewards = rootObject.getArray("rewards").getSuccess().flatMap(array -> array.getAsList((i, element) -> SkillRewardConfig.parse(element, context)).mapFailure(Problem::combine).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        Integer cost = rootObject.get("cost").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(1);
        Integer requiredSkills = rootObject.get("required_skills").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(1);
        Integer requiredPoints = rootObject.get("required_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Integer requiredSpentPoints = rootObject.get("required_spent_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Integer requiredExclusions = rootObject.get("required_exclusions").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(1);
        rootObject.get("metadata");
        if (problems.isEmpty()) {
            return Result.success(new SkillDefinitionConfig(id, (Component)optTitle.orElseThrow(), description, extraDescription, (IconConfig)optIcon.orElseThrow(), frame, size.floatValue(), rewards, cost, requiredSkills, requiredPoints, requiredSpentPoints, requiredExclusions));
        }
        return Result.failure(Problem.combine(problems));
    }

    public void dispose(DisposeContext context) {
        for (SkillRewardConfig reward : this.rewards) {
            reward.dispose(context);
        }
    }

    public String getId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public Component getExtraDescription() {
        return this.extraDescription;
    }

    public FrameConfig getFrame() {
        return this.frame;
    }

    public float getSize() {
        return this.size;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public List<SkillRewardConfig> getRewards() {
        return this.rewards;
    }

    public int getCost() {
        return this.cost;
    }

    public int getRequiredSkills() {
        return this.requiredSkills;
    }

    public int getRequiredPoints() {
        return this.requiredPoints;
    }

    public int getRequiredSpentPoints() {
        return this.requiredSpentPoints;
    }

    public int getRequiredExclusions() {
        return this.requiredExclusions;
    }
}

