/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.main.NeoForgeClientMain;
import net.puffish.skillsmod.mixin.GameRulesAccessor;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.setup.ServerPlatform;
import net.puffish.skillsmod.server.setup.ServerRegistrar;

@Mod(value="puffish_skills")
public class NeoForgeMain {
    private final List<ServerEventListener> serverListeners = new ArrayList<ServerEventListener>();
    private final Map<ResourceLocation, PacketBuilder> packetBuilders = new HashMap<ResourceLocation, PacketBuilder>();

    public NeoForgeMain(IEventBus modEventBus, Dist dist) {
        if (dist.isClient()) {
            new NeoForgeClientMain(this.packetBuilders);
        }
        SkillsMod.setup(FMLPaths.CONFIGDIR.get(), new ServerRegistrarImpl(modEventBus), new ServerEventReceiverImpl(), new ServerPacketSenderImpl(), new ServerPlatformImpl());
        modEventBus.addListener(this::onRegisterPayloadHandler);
        IEventBus neoForgeEventBus = NeoForge.EVENT_BUS;
        neoForgeEventBus.addListener(this::onPlayerLoggedIn);
        neoForgeEventBus.addListener(this::onPlayerLoggedOut);
        neoForgeEventBus.addListener(this::onServerStarting);
        neoForgeEventBus.addListener(this::onOnDatapackSyncEvent);
        neoForgeEventBus.addListener(this::onRegisterCommands);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (ServerEventListener listener : this.serverListeners) {
                listener.onPlayerJoin(serverPlayer);
            }
        }
    }

    private void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (ServerEventListener listener : this.serverListeners) {
                listener.onPlayerLeave(serverPlayer);
            }
        }
    }

    private void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onServerStarting(server);
        }
    }

    private void onOnDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        MinecraftServer server = event.getPlayerList().getServer();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onServerReload(server);
        }
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onCommandsRegister((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("puffish_skills");
        for (Map.Entry<ResourceLocation, PacketBuilder> entry : this.packetBuilders.entrySet()) {
            ResourceLocation id = entry.getKey();
            registrar.play(id, buf -> new SharedCustomPayload(id, new FriendlyByteBuf(Unpooled.buffer()).writeBytes((ByteBuf)buf)), entry.getValue()::apply);
        }
    }

    private class ServerRegistrarImpl
    implements ServerRegistrar {
        private final IEventBus modEventBus;

        public ServerRegistrarImpl(IEventBus modEventBus) {
            this.modEventBus = modEventBus;
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.key(), (String)id.getNamespace());
            deferredRegister.register(id.getPath(), () -> entry);
            deferredRegister.register(this.modEventBus);
        }

        @Override
        public <T extends GameRules.Value<T>> void registerGameRule(GameRules.Key<T> key, GameRules.Type<T> type) {
            GameRulesAccessor.getRuleTypes().put(key, type);
        }

        @Override
        public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void registerArgumentType(ResourceLocation id, Class<A> clazz, ArgumentTypeInfo<A, T> serializer) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)id.getNamespace());
            deferredRegister.register(id.getPath(), () -> serializer);
            deferredRegister.register(this.modEventBus);
            ArgumentTypeInfos.registerByClass(clazz, serializer);
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation id, Function<FriendlyByteBuf, T> reader, ServerPacketHandler<T> handler) {
            NeoForgeMain.this.packetBuilders.computeIfAbsent(id, key -> new PacketBuilder()).setServerHandler((IPlayPayloadHandler<SharedCustomPayload>)((IPlayPayloadHandler)(payload, context) -> {
                InPacket packet = (InPacket)reader.apply(payload.data());
                context.workHandler().execute(() -> handler.handle((ServerPlayer)context.player().orElseThrow(), packet));
            }));
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
            NeoForgeMain.this.packetBuilders.computeIfAbsent(id, key -> new PacketBuilder()).fallbackClientHandler();
        }
    }

    private class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            NeoForgeMain.this.serverListeners.add(eventListener);
        }
    }

    private static class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(ServerPlayer player, OutPacket packet) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.write(buf);
            player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SharedCustomPayload(packet.getId(), buf)));
        }
    }

    private static class ServerPlatformImpl
    implements ServerPlatform {
        private ServerPlatformImpl() {
        }

        @Override
        public boolean isFakePlayer(ServerPlayer player) {
            return player instanceof FakePlayer;
        }
    }

    public static class PacketBuilder {
        private Optional<IPlayPayloadHandler<SharedCustomPayload>> clientHandler = Optional.empty();
        private Optional<IPlayPayloadHandler<SharedCustomPayload>> serverHandler = Optional.empty();
        private boolean fallbackClient = false;
        private boolean fallbackServer = false;

        public void setClientHandler(IPlayPayloadHandler<SharedCustomPayload> handler) {
            if (this.clientHandler.isPresent()) {
                throw new IllegalStateException();
            }
            this.clientHandler = Optional.of(handler);
        }

        public void setServerHandler(IPlayPayloadHandler<SharedCustomPayload> handler) {
            if (this.serverHandler.isPresent()) {
                throw new IllegalStateException();
            }
            this.serverHandler = Optional.of(handler);
        }

        public void fallbackClientHandler() {
            this.fallbackClient = true;
        }

        public void fallbackServerHandler() {
            this.fallbackServer = true;
        }

        public void apply(IDirectionAwarePayloadHandlerBuilder<SharedCustomPayload, IPlayPayloadHandler<SharedCustomPayload>> handlers) {
            this.clientHandler.ifPresentOrElse(arg_0 -> handlers.client(arg_0), () -> {
                if (this.fallbackClient) {
                    handlers.client((payload, context) -> {});
                }
            });
            this.serverHandler.ifPresentOrElse(arg_0 -> handlers.server(arg_0), () -> {
                if (this.fallbackServer) {
                    handlers.server((payload, context) -> {});
                }
            });
        }
    }

    public record SharedCustomPayload(ResourceLocation id, FriendlyByteBuf data) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            buf.writeBytes(this.data.slice());
        }
    }
}

