/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ScoreboardOperation
implements Operation<Entity, Double> {
    private final String objectiveName;

    private ScoreboardOperation(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public static void register() {
        BuiltinPrototypes.ENTITY.registerOperation(SkillsMod.createIdentifier("get_score"), BuiltinPrototypes.NUMBER, ScoreboardOperation::parse);
        LegacyBuiltinPrototypes.registerAlias(BuiltinPrototypes.ENTITY, SkillsMod.createIdentifier("scoreboard"), SkillsMod.createIdentifier("get_score"));
    }

    public static Result<ScoreboardOperation, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(ScoreboardOperation::parse, context));
    }

    public static Result<ScoreboardOperation, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<String> optScoreboard = rootObject.getString("objective").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new ScoreboardOperation(optScoreboard.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Double> apply(Entity entity) {
        Scoreboard scoreboard = entity.level().getScoreboard();
        return Optional.ofNullable(scoreboard.getObjective(this.objectiveName)).map(objective -> Optional.ofNullable(scoreboard.getPlayerScoreInfo((ScoreHolder)entity, objective)).map(score -> score.value()).orElse(0.0));
    }
}

