/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.OversizedItemRenderer;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.OversizedItemRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.puffish.skillsmod.access.DrawContextAccess;
import net.puffish.skillsmod.access.GameRendererAccess;
import net.puffish.skillsmod.access.GuiRendererAccess;
import net.puffish.skillsmod.mixin.GuiRendererInvoker;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class ItemBatchedRenderer {
    private final Map<ComparableItemStack, List<Matrix3x2f>> batch = new HashMap<ComparableItemStack, List<Matrix3x2f>>();
    private static final Object KEY = new Object();

    public void emitItem(GuiGraphics context, ItemStack item, int x, int y) {
        List emits = this.batch.computeIfAbsent(new ComparableItemStack(item), key -> new ArrayList());
        emits.add(new Matrix3x2f((Matrix3x2fc)context.pose()).translate((float)(x - 8), (float)(y - 8)));
    }

    public void draw(GuiGraphics context, ScreenRectangle scissorArea) {
        Minecraft client = Minecraft.getInstance();
        GameRenderer gameRenderer = client.gameRenderer;
        GameRendererAccess gameRendererAccess = (GameRendererAccess)gameRenderer;
        GuiRendererAccess guiRendererAccess = (GuiRendererAccess)gameRendererAccess.getGuiRenderer();
        GuiRendererInvoker guiRendererInvoker = (GuiRendererInvoker)gameRendererAccess.getGuiRenderer();
        DrawContextAccess contextAccess = (DrawContextAccess)context;
        GuiRenderState guiRenderState = contextAccess.getState();
        int windowScaleFactor = guiRendererInvoker.invokeGetWindowScaleFactor();
        MultiBufferSource.BufferSource vertexConsumers = guiRendererAccess.getVertexConsumers();
        for (Map.Entry<ComparableItemStack, List<Matrix3x2f>> entry : this.batch.entrySet()) {
            ItemStack itemStack = entry.getKey().itemStack;
            TrackingItemStackRenderState itemRenderState = new TrackingItemStackRenderState();
            client.getItemModelResolver().updateForTopItem((ItemStackRenderState)itemRenderState, itemStack, ItemDisplayContext.GUI, (Level)client.level, (LivingEntity)client.player, 0);
            itemRenderState.appendModelIdentityElement(KEY);
            OversizedItemRenderer renderer = guiRendererAccess.getOversizedItems().computeIfAbsent(itemRenderState.getModelIdentity(), object -> new ItemGuiElementRenderer(vertexConsumers));
            for (Matrix3x2f matrix : entry.getValue()) {
                GuiItemRenderState renderState = new GuiItemRenderState(itemStack.getItem().getName().toString(), matrix, itemRenderState, 0, 0, scissorArea);
                AABB box = itemRenderState.getModelBoundingBox();
                renderer.prepare((PictureInPictureRenderState)new OversizedItemRenderState(renderState, 0, 0, Mth.ceil((double)(box.getXsize() * 16.0)), Mth.ceil((double)(box.getYsize() * 16.0))), guiRenderState, windowScaleFactor);
            }
        }
        this.batch.clear();
    }

    private record ComparableItemStack(ItemStack itemStack) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ItemStack.matches((ItemStack)this.itemStack, (ItemStack)((ComparableItemStack)o).itemStack);
        }

        @Override
        public int hashCode() {
            return this.itemStack.getItem().hashCode();
        }
    }

    private static class ItemGuiElementRenderer
    extends OversizedItemRenderer {
        private Object modelKey;

        public ItemGuiElementRenderer(MultiBufferSource.BufferSource immediate) {
            super(immediate);
        }

        public void invalidateTexture() {
            this.modelKey = null;
        }

        protected void renderToTexture(OversizedItemRenderState renderState, PoseStack matrixStack) {
            matrixStack.scale(1.0f, -1.0f, -1.0f);
            GuiItemRenderState guiItemRenderState = renderState.guiItemRenderState();
            TrackingItemStackRenderState itemRenderState = guiItemRenderState.itemStackRenderState();
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(itemRenderState.usesBlockLight() ? Lighting.Entry.ITEMS_3D : Lighting.Entry.ITEMS_FLAT);
            itemRenderState.render(matrixStack, (MultiBufferSource)this.bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            this.modelKey = itemRenderState.getModelIdentity();
        }

        public boolean textureIsReadyToBlit(OversizedItemRenderState renderState) {
            TrackingItemStackRenderState itemRenderState = renderState.guiItemRenderState().itemStackRenderState();
            return !itemRenderState.isAnimated() && itemRenderState.getModelIdentity().equals(this.modelKey);
        }
    }
}

