/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.Config;
import net.puffish.skillsmod.impl.json.JsonObjectTrackingImpl;
import net.puffish.skillsmod.util.VersionContext;

public class LegacyUtils {
    public static boolean isRemoved(int removalVersion, ConfigContext context) {
        if (context instanceof VersionContext) {
            VersionContext versionContext = (VersionContext)((Object)context);
            return versionContext.getVersion() >= removalVersion;
        }
        return true;
    }

    public static <S, F> Optional<S> deprecated(Supplier<? extends Result<S, F>> supplier, int removalVersion, ConfigContext context) {
        if (LegacyUtils.isRemoved(removalVersion, context)) {
            return Optional.empty();
        }
        return supplier.get().getSuccess();
    }

    public static <S, F> Function<F, Result<S, F>> wrapDeprecated(Supplier<? extends Result<S, F>> supplier, int removalVersion, ConfigContext context) {
        if (LegacyUtils.isRemoved(removalVersion, context)) {
            return Result::failure;
        }
        return f -> ((Result)supplier.get()).mapFailure(f2 -> f);
    }

    public static <S> Function<JsonObject, Result<S, Problem>> wrapNoUnused(Function<JsonObject, ? extends Result<S, Problem>> function, ConfigContext context) {
        return jsonObject -> {
            JsonObjectTrackingImpl tracking = new JsonObjectTrackingImpl((JsonObject)jsonObject);
            Result result = (Result)function.apply(tracking);
            List<Problem> problems = tracking.reportUnusedEntries();
            if (!problems.isEmpty()) {
                if (LegacyUtils.isRemoved(3, context)) {
                    problems = new ArrayList<Problem>(problems);
                    result.ifFailure(problems::add);
                    return Result.failure(Problem.combine(problems));
                }
                context.emitWarning(Problem.combine(problems).toString());
            }
            return result;
        };
    }

    public static <C extends Config> Function<JsonObject, Result<C, Problem>> wrapNoUnusedConfig(Function<JsonObject, ? extends Result<C, Problem>> function, ConfigContext context) {
        return jsonObject -> {
            JsonObjectTrackingImpl tracking = new JsonObjectTrackingImpl((JsonObject)jsonObject);
            return ((Result)function.apply(tracking)).andThen(config -> {
                List<Problem> problems = tracking.reportUnusedEntries();
                if (!problems.isEmpty()) {
                    if (config.version() >= 3) {
                        return Result.failure(Problem.combine(problems));
                    }
                    context.emitWarning(Problem.combine(problems).toString());
                }
                return Result.success(config);
            });
        };
    }
}

