/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class EntityCondition
implements Operation<Entity, Boolean> {
    private final Optional<HolderSet<EntityType<?>>> optEntityTypeEntries;
    private final Optional<NbtPredicate> optNbt;

    private EntityCondition(Optional<HolderSet<EntityType<?>>> optEntityTypeEntries, Optional<NbtPredicate> optNbt) {
        this.optEntityTypeEntries = optEntityTypeEntries;
        this.optNbt = optNbt;
    }

    public static void register() {
        BuiltinPrototypes.ENTITY.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, EntityCondition::parse);
    }

    public static Result<EntityCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen((? super S rootObject) -> rootObject.noUnused(EntityCondition::parse));
    }

    public static Result<EntityCondition, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<HolderSet<EntityType<?>>> optEntityType = rootObject.get("entity_type").getSuccess().flatMap(entityElement -> BuiltinJson.parseEntityTypeOrEntityTypeTag(entityElement).ifFailure(problems::add).getSuccess());
        Optional<NbtPredicate> optNbt = rootObject.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbtPredicate(nbtElement).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new EntityCondition(optEntityType, optNbt));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(Entity entity) {
        return Optional.of(this.optEntityTypeEntries.map(entityTypeEntries -> entity.m_6095_().m_293227_(entityTypeEntries)).orElse(true) != false && this.optNbt.map(nbt -> nbt.m_57477_(entity)).orElse(true) != false);
    }
}

