/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public class CommandReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("command");
    private final Map<UUID, Integer> counts = new HashMap<UUID, Integer>();
    private final String command;
    private final String unlockCommand;
    private final String lockCommand;

    private CommandReward(String command, String unlockCommand, String lockCommand) {
        this.command = command;
        this.unlockCommand = unlockCommand;
        this.lockCommand = lockCommand;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, CommandReward::parse);
    }

    private static Result<CommandReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(CommandReward::parse, context));
    }

    private static Result<CommandReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        String command = rootObject.get("command").getSuccess().flatMap(jsonElement -> jsonElement.getAsString().ifFailure(problems::add).getSuccess()).orElse("");
        String unlockCommand = rootObject.get("unlock_command").getSuccess().flatMap(jsonElement -> jsonElement.getAsString().ifFailure(problems::add).getSuccess()).orElse("");
        String lockCommand = rootObject.get("lock_command").getSuccess().flatMap(jsonElement -> jsonElement.getAsString().ifFailure(problems::add).getSuccess()).orElse("");
        if (problems.isEmpty()) {
            return Result.success(new CommandReward(command, unlockCommand, lockCommand));
        }
        return Result.failure(Problem.combine(problems));
    }

    private void executeCommand(ServerPlayer player, String command) {
        if (command.isBlank()) {
            return;
        }
        MinecraftServer server = SkillsMod.getInstance().getPlayerServer(player);
        server.m_129892_().m_230957_(player.m_20203_().m_81324_().m_81325_(server.m_7034_()), command);
    }

    @Override
    public void update(RewardUpdateContext context) {
        ServerPlayer player = context.getPlayer();
        if (context.isAction()) {
            this.executeCommand(player, this.command);
        }
        this.counts.compute(player.m_20148_(), (uuid, count) -> {
            Integer n;
            if (count == null) {
                count = 0;
            }
            while (context.getCount() > count) {
                this.executeCommand(player, this.unlockCommand);
                n = count;
                count = count + 1;
            }
            while (context.getCount() < count) {
                this.executeCommand(player, this.lockCommand);
                n = count;
                count = count - 1;
            }
            return count;
        });
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        for (Map.Entry<UUID, Integer> entry : this.counts.entrySet()) {
            ServerPlayer player = context.getServer().m_6846_().m_11259_(entry.getKey());
            if (player == null) continue;
            for (int i = 0; i < entry.getValue(); ++i) {
                this.executeCommand(player, this.lockCommand);
            }
        }
        this.counts.clear();
    }
}

