/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.calculation.prototype;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;

public final class BuiltinPrototypes {
    public static final Prototype<Double> NUMBER = Prototype.create(SkillsMod.createIdentifier("number"));
    public static final Prototype<Boolean> BOOLEAN = Prototype.create(SkillsMod.createIdentifier("boolean"));
    public static final Prototype<MinecraftServer> SERVER = Prototype.create(new ResourceLocation("server"));
    public static final Prototype<ServerLevel> WORLD = Prototype.create(new ResourceLocation("world"));
    public static final Prototype<EntityType<?>> ENTITY_TYPE = Prototype.create(new ResourceLocation("entity_type"));
    public static final Prototype<Entity> ENTITY = Prototype.create(new ResourceLocation("entity"));
    public static final Prototype<LivingEntity> LIVING_ENTITY = Prototype.create(new ResourceLocation("living_entity"));
    public static final Prototype<ServerPlayer> PLAYER = Prototype.create(new ResourceLocation("player"));
    public static final Prototype<Item> ITEM = Prototype.create(new ResourceLocation("item"));
    public static final Prototype<ItemStack> ITEM_STACK = Prototype.create(new ResourceLocation("item_stack"));
    public static final Prototype<Block> BLOCK = Prototype.create(new ResourceLocation("block"));
    public static final Prototype<BlockState> BLOCK_STATE = Prototype.create(new ResourceLocation("block_state"));
    public static final Prototype<DamageType> DAMAGE_TYPE = Prototype.create(new ResourceLocation("damage_type"));
    public static final Prototype<DamageSource> DAMAGE_SOURCE = Prototype.create(new ResourceLocation("damage_source"));
    public static final Prototype<StatType<?>> STAT_TYPE = Prototype.create(new ResourceLocation("stat_type"));
    public static final Prototype<Stat<?>> STAT = Prototype.create(new ResourceLocation("stat"));
    public static final Prototype<MobEffectInstance> STATUS_EFFECT_INSTANCE = Prototype.create(new ResourceLocation("status_effect_instance"));
    public static final Prototype<AttributeInstance> ENTITY_ATTRIBUTE_INSTANCE = Prototype.create(new ResourceLocation("entity_attribute_instance"));

    private BuiltinPrototypes() {
    }

    static {
        WORLD.registerOperation(new ResourceLocation("get_server"), SERVER, OperationFactory.create(ServerLevel::getServer));
        WORLD.registerOperation(new ResourceLocation("get_time_of_day"), NUMBER, OperationFactory.create(world -> world.getDayTime()));
        ENTITY.registerOperation(new ResourceLocation("get_type"), ENTITY_TYPE, OperationFactory.create(Entity::getType));
        ENTITY.registerOperation(new ResourceLocation("get_world"), WORLD, OperationFactory.create(entity -> (ServerLevel)entity.level()));
        LIVING_ENTITY.registerOperation(new ResourceLocation("as_entity"), ENTITY, OperationFactory.create(p -> p));
        LIVING_ENTITY.registerOperation(new ResourceLocation("get_world"), WORLD, OperationFactory.create(livingEntity -> (ServerLevel)livingEntity.level()));
        LIVING_ENTITY.registerOperation(new ResourceLocation("get_type"), ENTITY_TYPE, OperationFactory.create(Entity::getType));
        LIVING_ENTITY.registerOperation(new ResourceLocation("get_max_health"), NUMBER, OperationFactory.create(livingEntity -> livingEntity.getMaxHealth()));
        LIVING_ENTITY.registerOperation(new ResourceLocation("get_health"), NUMBER, OperationFactory.create(livingEntity -> livingEntity.getHealth()));
        PLAYER.registerOperation(new ResourceLocation("as_living_entity"), LIVING_ENTITY, OperationFactory.create(p -> p));
        PLAYER.registerOperation(new ResourceLocation("as_entity"), ENTITY, OperationFactory.create(p -> p));
        PLAYER.registerOperation(new ResourceLocation("get_world"), WORLD, OperationFactory.create(player -> (ServerLevel)player.level()));
        ITEM.registerOperation(new ResourceLocation("get_saturation_modifier"), NUMBER, OperationFactory.create(item -> {
            FoodProperties fc = item.getFoodProperties();
            return fc == null ? 0.0 : (double)fc.getSaturationModifier();
        }));
        ITEM.registerOperation(new ResourceLocation("get_nutrition"), NUMBER, OperationFactory.create(item -> {
            FoodProperties fc = item.getFoodProperties();
            return fc == null ? 0.0 : (double)fc.getNutrition();
        }));
        ITEM_STACK.registerOperation(new ResourceLocation("get_item"), ITEM, OperationFactory.create(ItemStack::getItem));
        ITEM_STACK.registerOperation(new ResourceLocation("get_count"), NUMBER, OperationFactory.create(itemStack -> itemStack.getCount()));
        BLOCK.registerOperation(new ResourceLocation("get_hardness"), NUMBER, OperationFactory.create(block -> block.defaultDestroyTime()));
        BLOCK.registerOperation(new ResourceLocation("get_blast_resistance"), NUMBER, OperationFactory.create(block -> block.getExplosionResistance()));
        BLOCK_STATE.registerOperation(new ResourceLocation("get_block"), BLOCK, OperationFactory.create(BlockBehaviour.BlockStateBase::getBlock));
        DAMAGE_SOURCE.registerOperation(new ResourceLocation("get_type"), DAMAGE_TYPE, OperationFactory.create(DamageSource::type));
        DAMAGE_SOURCE.registerOperation(new ResourceLocation("get_attacker"), ENTITY, OperationFactory.createOptional(damageSource -> Optional.ofNullable(damageSource.getEntity())));
        DAMAGE_SOURCE.registerOperation(new ResourceLocation("get_source"), ENTITY, OperationFactory.createOptional(damageSource -> Optional.ofNullable(damageSource.getDirectEntity())));
        STAT.registerOperation(new ResourceLocation("get_type"), STAT_TYPE, OperationFactory.create(Stat::getType));
        STATUS_EFFECT_INSTANCE.registerOperation(new ResourceLocation("get_level"), NUMBER, OperationFactory.create(effect -> effect.getAmplifier() + 1));
        STATUS_EFFECT_INSTANCE.registerOperation(new ResourceLocation("get_duration"), NUMBER, OperationFactory.create(effect -> effect.getDuration()));
        ENTITY_ATTRIBUTE_INSTANCE.registerOperation(new ResourceLocation("get_value"), NUMBER, OperationFactory.create(AttributeInstance::getValue));
        ENTITY_ATTRIBUTE_INSTANCE.registerOperation(new ResourceLocation("get_base_value"), NUMBER, OperationFactory.create(AttributeInstance::getBaseValue));
    }
}

