/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillScreenData;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.gui.SimpleToast;
import net.puffish.skillsmod.client.gui.SkillsScreen;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.network.packets.in.ExperienceUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.HideCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.NewPointInPacket;
import net.puffish.skillsmod.client.network.packets.in.OpenScreenInPacket;
import net.puffish.skillsmod.client.network.packets.in.PointsUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.ShowCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.ShowToastInPacket;
import net.puffish.skillsmod.client.network.packets.in.SkillUpdateInPacket;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.util.ToastType;

public class SkillsClientMod {
    public static final KeyMapping OPEN_KEY_BINDING = new KeyMapping("key.puffish_skills.open", InputConstants.Type.KEYSYM, 75, "category.puffish_skills.skills");
    private static SkillsClientMod instance;
    private final ClientSkillScreenData screenData = new ClientSkillScreenData();
    private final ClientPacketSender packetSender;

    private SkillsClientMod(ClientPacketSender packetSender) {
        this.packetSender = packetSender;
    }

    public static SkillsClientMod getInstance() {
        return instance;
    }

    public static void setup(ClientRegistrar registrar, ClientEventReceiver eventReceiver, KeyBindingReceiver keyBindingReceiver, ClientPacketSender packetSender) {
        instance = new SkillsClientMod(packetSender);
        keyBindingReceiver.registerKeyBinding(OPEN_KEY_BINDING, instance::onOpenKeyPress);
        registrar.registerInPacket(Packets.SHOW_CATEGORY, ShowCategoryInPacket::read, instance::onShowCategory);
        registrar.registerInPacket(Packets.HIDE_CATEGORY, HideCategoryInPacket::read, instance::onHideCategory);
        registrar.registerInPacket(Packets.SKILL_UPDATE, SkillUpdateInPacket::read, instance::onSkillUpdatePacket);
        registrar.registerInPacket(Packets.POINTS_UPDATE, PointsUpdateInPacket::read, instance::onPointsUpdatePacket);
        registrar.registerInPacket(Packets.EXPERIENCE_UPDATE, ExperienceUpdateInPacket::read, instance::onExperienceUpdatePacket);
        registrar.registerInPacket(Packets.SHOW_TOAST, ShowToastInPacket::read, instance::onShowToast);
        registrar.registerInPacket(Packets.OPEN_SCREEN, OpenScreenInPacket::read, instance::onOpenScreenPacket);
        registrar.registerInPacket(Packets.NEW_POINT, NewPointInPacket::read, instance::onNewPointPacket);
        registrar.registerOutPacket(Packets.SKILL_CLICK);
        eventReceiver.registerListener(instance.new EventListener());
    }

    private void onOpenKeyPress() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof SkillsScreen) {
            SkillsScreen screen2 = (SkillsScreen)screen;
            screen2.onClose();
        } else {
            this.openScreen(Optional.empty());
        }
    }

    private void onShowCategory(ShowCategoryInPacket packet) {
        ClientCategoryData category = packet.getCategory();
        this.screenData.putCategory(category.getConfig().id(), category);
    }

    private void onHideCategory(HideCategoryInPacket packet) {
        this.screenData.removeCategory(packet.getCategoryId());
    }

    private void onSkillUpdatePacket(SkillUpdateInPacket packet) {
        this.screenData.getCategory(packet.getCategoryId()).ifPresent(category -> {
            if (packet.isUnlocked()) {
                category.unlock(packet.getSkillId());
            } else {
                category.lock(packet.getSkillId());
            }
        });
    }

    private void onExperienceUpdatePacket(ExperienceUpdateInPacket packet) {
        this.screenData.getCategory(packet.getCategoryId()).ifPresent(category -> {
            category.setCurrentLevel(packet.getCurrentLevel());
            category.setCurrentExperience(packet.getCurrentExperience());
            category.setRequiredExperience(packet.getRequiredExperience());
        });
    }

    private void onPointsUpdatePacket(PointsUpdateInPacket packet) {
        this.screenData.getCategory(packet.getCategoryId()).ifPresent(category -> category.updatePoints(packet.getSpentPoints(), packet.getEarnedPoints()));
    }

    private void onNewPointPacket(NewPointInPacket packet) {
        this.screenData.getCategory(packet.getCategoryId()).ifPresent(category -> {
            if (category.hasAnySkillLeft()) {
                Minecraft.getInstance().gui.getChat().addMessage((Component)SkillsMod.createTranslatable("chat", "new_point", OPEN_KEY_BINDING.getTranslatedKeyMessage()));
            }
        });
    }

    private void onOpenScreenPacket(OpenScreenInPacket packet) {
        this.openScreen(packet.getCategoryId());
    }

    private void onShowToast(ShowToastInPacket packet) {
        Minecraft client = Minecraft.getInstance();
        ToastComponent toastComponent = client.getToasts();
        MutableComponent mutableComponent = Component.literal((String)"Pufferfish's Skills");
        toastComponent.addToast((Toast)SimpleToast.create(client, (Component)mutableComponent, (Component)SkillsMod.createTranslatable("toast", (switch (packet.getToastType()) {
            default -> throw new IncompatibleClassChangeError();
            case ToastType.INVALID_CONFIG -> "invalid_config";
            case ToastType.MISSING_CONFIG -> "missing_config";
        }) + ".description", new Object[0])));
    }

    public void openScreen(Optional<ResourceLocation> categoryId) {
        Minecraft.getInstance().setScreen((Screen)new SkillsScreen(this.screenData, categoryId));
    }

    public ClientPacketSender getPacketSender() {
        return this.packetSender;
    }

    private class EventListener
    implements ClientEventListener {
        private EventListener() {
        }

        @Override
        public void onPlayerJoin() {
            SkillsClientMod.this.screenData.clearCategories();
        }
    }
}

