/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ItemStackCondition
implements Operation<ItemStack, Boolean> {
    private final Optional<HolderSet<Item>> optItemEntries;
    private final Optional<NbtPredicate> optNbt;
    private final Optional<DataComponentPredicate> optComponents;

    private ItemStackCondition(Optional<HolderSet<Item>> optItemEntries, Optional<NbtPredicate> optNbt, Optional<DataComponentPredicate> optComponents) {
        this.optItemEntries = optItemEntries;
        this.optNbt = optNbt;
        this.optComponents = optComponents;
    }

    public static void register() {
        BuiltinPrototypes.ITEM_STACK.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, ItemStackCondition::parse);
    }

    public static Result<ItemStackCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(rootObject -> ItemStackCondition.parse(rootObject, context), context));
    }

    public static Result<ItemStackCondition, Problem> parse(JsonObject rootObject, OperationConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<HolderSet<Item>> optItem = rootObject.get("item").getSuccess().flatMap(itemElement -> BuiltinJson.parseItemOrItemTag(itemElement).ifFailure(problems::add).getSuccess());
        Optional<NbtPredicate> optNbt = rootObject.get("nbt").getSuccess().flatMap(stateElement -> BuiltinJson.parseNbtPredicate(stateElement).ifFailure(problems::add).getSuccess());
        Optional<DataComponentPredicate> optComponents = rootObject.get("components").getSuccess().flatMap(stateElement -> BuiltinJson.parseComponentPredicate(stateElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new ItemStackCondition(optItem, optNbt, optComponents));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(ItemStack itemStack) {
        return Optional.of(this.optItemEntries.map(arg_0 -> ((ItemStack)itemStack).is(arg_0)).orElse(true) != false && this.optNbt.map(nbt -> nbt.matches(itemStack)).orElse(true) != false && this.optComponents.map(components -> components.test((DataComponentHolder)itemStack)).orElse(true) != false);
    }
}

