/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.puffish.skillsmod.access.MinecraftClientAccess;
import net.puffish.skillsmod.access.RenderLayerAccess;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ItemBatchedRenderer {
    private final Map<ComparableItemStack, List<Matrix4f>> batch = new HashMap<ComparableItemStack, List<Matrix4f>>();
    private final ItemStackRenderState itemRenderState = new ItemStackRenderState();

    public void emitItem(GuiGraphics context, ItemStack item, int x, int y) {
        List emits = this.batch.computeIfAbsent(new ComparableItemStack(item), key -> new ArrayList());
        emits.add(new Matrix4f((Matrix4fc)context.pose().last().pose()).translate((float)x, (float)y, 0.0f));
    }

    public void draw() {
        PoseStack matrices = new PoseStack();
        matrices.translate(0.0f, 0.0f, 150.0f);
        matrices.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrices.scale(16.0f, 16.0f, 16.0f);
        for (Map.Entry<ComparableItemStack, List<Matrix4f>> entry : this.batch.entrySet()) {
            ItemStack itemStack = entry.getKey().itemStack;
            Minecraft client = Minecraft.getInstance();
            client.getItemModelResolver().updateForTopItem(this.itemRenderState, itemStack, ItemDisplayContext.GUI, false, (Level)client.level, (LivingEntity)client.player, 0);
            if (this.itemRenderState.usesBlockLight()) {
                Lighting.setupFor3DItems();
            } else {
                Lighting.setupForFlatItems();
            }
            MinecraftClientAccess clientAccess = (MinecraftClientAccess)client;
            MultiBufferSource.BufferSource immediate = clientAccess.getBufferBuilders().bufferSource();
            HashSet layers = new HashSet();
            this.itemRenderState.render(matrices, layer -> {
                RenderLayerAccess layerAccess = (RenderLayerAccess)layer;
                layerAccess.setEmits((List)entry.getValue());
                layers.add(layerAccess);
                return immediate.getBuffer(layer);
            }, 0xF000F0, OverlayTexture.NO_OVERLAY);
            immediate.endBatch();
            for (RenderLayerAccess layer2 : layers) {
                layer2.setEmits(null);
            }
        }
        this.batch.clear();
    }

    private record ComparableItemStack(ItemStack itemStack) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ItemStack.matches((ItemStack)this.itemStack, (ItemStack)((ComparableItemStack)o).itemStack);
        }

        @Override
        public int hashCode() {
            return this.itemStack.getItem().hashCode();
        }
    }
}

