/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.expression;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.expression.BinaryOperator;
import net.puffish.skillsmod.expression.Expression;
import net.puffish.skillsmod.expression.FunctionOperator;
import net.puffish.skillsmod.expression.GroupOperator;
import net.puffish.skillsmod.expression.Parser;
import net.puffish.skillsmod.expression.UnaryOperator;

public class DefaultParser {
    private static final Map<String, Double> CONSTANTS = Map.ofEntries(Map.entry("e", Math.E), Map.entry("pi", Math.PI), Map.entry("tau", Math.PI * 2));
    private static final List<BinaryOperator<Double>> BINARY_OPERATORS = List.of(BinaryOperator.createLeft("|", 1, (l, r) -> v -> (Double)l.eval(v) == 0.0 && (Double)r.eval(v) == 0.0 ? 0.0 : 1.0), BinaryOperator.createLeft("&", 2, (l, r) -> v -> (Double)l.eval(v) == 0.0 || (Double)r.eval(v) == 0.0 ? 0.0 : 1.0), BinaryOperator.createLeft("+", 3, (l, r) -> v -> (Double)l.eval(v) + (Double)r.eval(v)), BinaryOperator.createLeft("-", 3, (l, r) -> v -> (Double)l.eval(v) - (Double)r.eval(v)), BinaryOperator.createLeft("*", 4, (l, r) -> v -> (Double)l.eval(v) * (Double)r.eval(v)), BinaryOperator.createLeft("/", 4, (l, r) -> v -> (Double)l.eval(v) / (Double)r.eval(v)), BinaryOperator.createRight("^", 6, (l, r) -> v -> Math.pow((Double)l.eval(v), (Double)r.eval(v))));
    private static final List<UnaryOperator<Double>> UNARY_OPERATORS = List.of(UnaryOperator.create("!", 5, e -> v -> (Double)e.eval(v) == 0.0 ? 1.0 : 0.0), UnaryOperator.create("+", 5, e -> v -> (double)((Double)e.eval(v))), UnaryOperator.create("-", 5, e -> v -> -((Double)e.eval(v)).doubleValue()));
    private static final List<GroupOperator> GROUP_OPERATORS = List.of(GroupOperator.create("(", ")"));
    private static final List<FunctionOperator<Double>> FUNCTIONS = List.of(FunctionOperator.create("sin", "(", ",", ")", 1, l -> v -> Math.sin((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("cos", "(", ",", ")", 1, l -> v -> Math.cos((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("tan", "(", ",", ")", 1, l -> v -> Math.tan((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("asin", "(", ",", ")", 1, l -> v -> Math.asin((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("acos", "(", ",", ")", 1, l -> v -> Math.acos((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("atan", "(", ",", ")", 1, l -> v -> Math.atan((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("atan2", "(", ",", ")", 2, l -> v -> Math.atan2((Double)((Expression)l.get(0)).eval(v), (Double)((Expression)l.get(1)).eval(v))), FunctionOperator.create("sinh", "(", ",", ")", 1, l -> v -> Math.sinh((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("cosh", "(", ",", ")", 1, l -> v -> Math.cosh((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("tanh", "(", ",", ")", 1, l -> v -> Math.tanh((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("log", "(", ",", ")", 1, l -> v -> Math.log((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("exp", "(", ",", ")", 1, l -> v -> Math.exp((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("sqrt", "(", ",", ")", 1, l -> v -> Math.sqrt((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("cbrt", "(", ",", ")", 1, l -> v -> Math.cbrt((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("floor", "(", ",", ")", 1, l -> v -> Math.floor((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("ceil", "(", ",", ")", 1, l -> v -> Math.ceil((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("round", "(", ",", ")", 1, l -> v -> Math.round((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("trunc", "(", ",", ")", 1, l -> v -> ((Double)((Expression)l.get(0)).eval(v)).longValue()), FunctionOperator.create("abs", "(", ",", ")", 1, l -> v -> Math.abs((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("sign", "(", ",", ")", 1, l -> v -> Math.signum((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("fract", "(", ",", ")", 1, l -> v -> Mth.frac((double)((Double)((Expression)l.get(0)).eval(v)))), FunctionOperator.create("mod", "(", ",", ")", 2, l -> v -> Mth.positiveModulo((double)((Double)((Expression)l.get(0)).eval(v)), (double)((Double)((Expression)l.get(1)).eval(v)))), FunctionOperator.create("mix", "(", ",", ")", 3, l -> v -> Mth.lerp((double)((Double)((Expression)l.get(2)).eval(v)), (double)((Double)((Expression)l.get(0)).eval(v)), (double)((Double)((Expression)l.get(1)).eval(v)))), FunctionOperator.create("clamp", "(", ",", ")", 3, l -> v -> Mth.clamp((double)((Double)((Expression)l.get(0)).eval(v)), (double)((Double)((Expression)l.get(1)).eval(v)), (double)((Double)((Expression)l.get(2)).eval(v)))), FunctionOperator.createVariadic("min", "(", ",", ")", l -> v -> {
        double x = Double.MAX_VALUE;
        for (Expression e : l) {
            x = Math.min(x, (Double)e.eval(v));
        }
        return x;
    }), FunctionOperator.createVariadic("max", "(", ",", ")", l -> v -> {
        double x = -1.7976931348623157E308;
        for (Expression e : l) {
            x = Math.max(x, (Double)e.eval(v));
        }
        return x;
    }));

    public static Result<Expression<Double>, Problem> parse(String expression, Set<String> variables) {
        return Parser.parse(expression, UNARY_OPERATORS, BINARY_OPERATORS, GROUP_OPERATORS, FUNCTIONS, token -> {
            if (variables.contains(token) || CONSTANTS.containsKey(token)) {
                return Result.success(v -> (Double)v.get(token));
            }
            try {
                double value = Double.parseDouble(token);
                return Result.success(v -> value);
            }
            catch (Exception e) {
                return Result.failure(Problem.message("Unknown variable `" + token + "`"));
            }
        }).mapSuccess(e -> v -> e.eval(new WithConstants(v)));
    }

    private record WithConstants(Map<String, Double> variables) implements Map<String, Double>
    {
        @Override
        public boolean containsKey(Object o) {
            return this.variables.containsKey(o) || CONSTANTS.containsKey(o);
        }

        @Override
        public Double get(Object o) {
            Double v = this.variables.get(o);
            return v != null ? v : CONSTANTS.get(o);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double put(String s, Double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Double> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Double> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Double>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

