/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.util.Problem;

public class ProblemImpl
implements Problem {
    private final List<String> messages;

    public ProblemImpl(String message) {
        this.messages = List.of(message);
    }

    public ProblemImpl(Collection<Problem> problems) {
        this.messages = problems.stream().flatMap(ProblemImpl::streamMessages).toList();
    }

    public ProblemImpl(Problem ... problems) {
        this.messages = Arrays.stream(problems).flatMap(ProblemImpl::streamMessages).toList();
    }

    @Override
    public String toString() {
        return this.messages.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public static Stream<String> streamMessages(Problem problem) {
        if (problem instanceof ProblemImpl) {
            ProblemImpl impl = (ProblemImpl)problem;
            return impl.messages.stream();
        }
        return Stream.of(problem.toString());
    }
}

