/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4fc;

public class TextureBatchedRenderer {
    private final Map<ResourceLocation, List<TextureEmit>> batch = new HashMap<ResourceLocation, List<TextureEmit>>();

    public void emitTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitSprite(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling scaling, int x, int y, int width, int height, Vector4fc color) {
        if (scaling instanceof GuiSpriteScaling.Stretch) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
        } else if (scaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)scaling;
            this.emitSpriteTile(context, sprite, tile, x, y, width, height, color);
        } else if (scaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
            this.emitSpriteNineSlice(context, sprite, nineSlice, x, y, width, height, color);
        }
    }

    private void emitSpriteTile(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling.Tile tile, int x, int y, int width, int height, Vector4fc color) {
        if (width <= 0 || height <= 0 || tile.width() <= 0 || tile.height() <= 0) {
            return;
        }
        for (int tileX = 0; tileX < width; tileX += tile.width()) {
            int tileWidth = Math.min(tile.width(), width - tileX);
            for (int tileY = 0; tileY < height; tileY += tile.height()) {
                int tileHeight = Math.min(tile.height(), height - tileY);
                this.emitSpriteStretch(context, sprite, x + tileX, y + tileY, tileWidth, tileHeight, color);
            }
        }
    }

    private void emitSpriteNineSlice(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling.NineSlice nineSlice, int x, int y, int width, int height, Vector4fc color) {
        int tileWidth;
        int tileX;
        if (width == nineSlice.width() && height == nineSlice.height()) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
            return;
        }
        GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
        int left = Math.min(border.left(), width / 2);
        int top = Math.min(border.top(), height / 2);
        int right = Math.min(border.right(), width / 2);
        int bottom = Math.min(border.bottom(), height / 2);
        if (width == nineSlice.width()) {
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + width, y + top, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV((float)top / (float)nineSlice.height()), color);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.height() - top - bottom) {
                int tileHeight = Math.min(nineSlice.height() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.atlasLocation(), x, y + tileY, x + nineSlice.width(), y + tileY + tileHeight, sprite.getU0(), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU1(), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
            }
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y + height - bottom, x + width, y + height, sprite.getU0(), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU1(), sprite.getV1(), color);
            return;
        }
        if (height == nineSlice.height()) {
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + left, y + height, sprite.getU0(), sprite.getV0(), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV1(), color);
            for (int tileX2 = left; tileX2 < width - right; tileX2 += nineSlice.width() - left - right) {
                int tileWidth2 = Math.min(nineSlice.width() - left - right, width - right - tileX2);
                this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX2, y, x + tileX2 + tileWidth2, y + nineSlice.height(), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV0(), sprite.getU((float)(left + tileWidth2) / (float)nineSlice.width()), sprite.getV1(), color);
            }
            this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y, x + width, y + height, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV0(), sprite.getU1(), sprite.getV1(), color);
            return;
        }
        this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + left, y + right, sprite.getU0(), sprite.getV0(), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)right / (float)nineSlice.width()), color);
        this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y, x + width, y + top, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV0(), sprite.getU1(), sprite.getV((float)top / (float)nineSlice.height()), color);
        this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y + height - bottom, x + width, y + height, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU1(), sprite.getV1(), color);
        this.emitTextureBatched(context, sprite.atlasLocation(), x, y + height - bottom, x + left, y + height, sprite.getU0(), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV1(), color);
        for (tileX = left; tileX < width - right; tileX += nineSlice.width() - left - right) {
            tileWidth = Math.min(nineSlice.width() - left - right, width - right - tileX);
            this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX, y, x + tileX + tileWidth, y + top, sprite.getU((float)left / (float)nineSlice.width()), sprite.getV0(), sprite.getU((float)(left + tileWidth) / (float)nineSlice.width()), sprite.getV((float)top / (float)nineSlice.height()), color);
            this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX, y + height - bottom, x + tileX + tileWidth, y + height, sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU((float)(left + tileWidth) / (float)nineSlice.width()), sprite.getV1(), color);
        }
        for (int tileY = top; tileY < height - bottom; tileY += nineSlice.height() - top - bottom) {
            int tileHeight = Math.min(nineSlice.height() - top - bottom, height - bottom - tileY);
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y + tileY, x + left, y + tileY + tileHeight, sprite.getU0(), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
            this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y + tileY, x + width, y + tileY + tileHeight, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU1(), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
        }
        for (tileX = left; tileX < width - right; tileX += nineSlice.width() - left - right) {
            tileWidth = Math.min(nineSlice.width() - left - right, width - right - tileX);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.height() - top - bottom) {
                int tileHeight = Math.min(nineSlice.height() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX, y + tileY, x + tileX + tileWidth, y + tileY + tileHeight, sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU((float)(left + tileWidth) / (float)nineSlice.width()), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
            }
        }
    }

    private void emitSpriteStretch(GuiGraphics context, TextureAtlasSprite sprite, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + width, y + height, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), color);
    }

    private void emitTextureBatched(GuiGraphics context, ResourceLocation texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix4f matrix = context.pose().last().pose();
        Vector3f v1 = matrix.transformPosition(new Vector3f(minX, minY, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(minX, maxY, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(maxX, maxY, 0.0f));
        Vector3f v4 = matrix.transformPosition(new Vector3f(maxX, minY, 0.0f));
        emits.add(new TextureEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, v4.x, v4.y, v4.z, minU, minV, maxU, maxV, color));
    }

    public void draw(GuiGraphics context) {
        context.drawSpecial(vcp -> {
            for (Map.Entry<ResourceLocation, List<TextureEmit>> entry : this.batch.entrySet()) {
                VertexConsumer vc = vcp.getBuffer(RenderType.guiTextured((ResourceLocation)entry.getKey()));
                for (TextureEmit emit : entry.getValue()) {
                    vc.addVertex(emit.x1, emit.y1, emit.z1).setUv(emit.minU, emit.minV).setColor(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                    vc.addVertex(emit.x2, emit.y2, emit.z2).setUv(emit.minU, emit.maxV).setColor(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                    vc.addVertex(emit.x3, emit.y3, emit.z3).setUv(emit.maxU, emit.maxV).setColor(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                    vc.addVertex(emit.x4, emit.y4, emit.z4).setUv(emit.maxU, emit.minV).setColor(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                }
            }
        });
        this.batch.clear();
    }

    private record TextureEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, Vector4fc color) {
    }
}

