/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.BackgroundConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.colors.ColorsConfig;
import net.puffish.skillsmod.util.LegacyUtils;

public record GeneralConfig(Component title, Component description, Component extraDescription, IconConfig icon, BackgroundConfig background, ColorsConfig colors, boolean unlockedByDefault, int startingPoints, boolean exclusiveRoot, int spentPointsLimit) {
    public static Result<GeneralConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> GeneralConfig.parse(rootObject, context), context));
    }

    public static Result<GeneralConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optTitle = rootObject.get("title").andThen(titleElement -> BuiltinJson.parseText(titleElement, (RegistryAccess)context.getServer().registryAccess())).ifFailure(problems::add).getSuccess();
        Component description = rootObject.get("description").getSuccess().flatMap(descriptionElement -> BuiltinJson.parseText(descriptionElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess()).orElseGet(Component::empty);
        Component extraDescription = rootObject.get("extra_description").getSuccess().flatMap(descriptionElement -> BuiltinJson.parseText(descriptionElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess()).orElseGet(Component::empty);
        Optional optIcon = rootObject.get("icon").andThen(element -> IconConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        Optional optBackground = rootObject.get("background").andThen(element -> BackgroundConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        ColorsConfig colors = rootObject.get("colors").getSuccess().flatMap(element -> ColorsConfig.parse(element, context).ifFailure(problems::add).getSuccess()).orElseGet(ColorsConfig::createDefault);
        Boolean unlockedByDefault = rootObject.get("unlocked_by_default").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(true);
        Integer startingPoints = rootObject.get("starting_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Boolean exclusiveRoot = rootObject.get("exclusive_root").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(false);
        Integer spentPointsLimit = rootObject.get("spent_points_limit").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(Integer.MAX_VALUE);
        if (problems.isEmpty()) {
            return Result.success(new GeneralConfig((Component)optTitle.orElseThrow(), description, extraDescription, (IconConfig)optIcon.orElseThrow(), (BackgroundConfig)optBackground.orElseThrow(), colors, unlockedByDefault, startingPoints, exclusiveRoot, spentPointsLimit));
        }
        return Result.failure(Problem.combine(problems));
    }
}

