/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.access.DrawContextAccess;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;

public class TextureBatchedRenderer {
    private final Map<ResourceLocation, List<TextureEmit>> batch = new HashMap<ResourceLocation, List<TextureEmit>>();

    public void emitTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitSprite(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling scaling, int x, int y, int width, int height, int color) {
        if (scaling instanceof GuiSpriteScaling.Stretch) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
        } else if (scaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)scaling;
            this.emitSpriteTile(context, sprite, tile, x, y, width, height, color);
        } else if (scaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
            this.emitSpriteNineSlice(context, sprite, nineSlice, x, y, width, height, color);
        }
    }

    private void emitSpriteTile(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling.Tile tile, int x, int y, int width, int height, int color) {
        if (width <= 0 || height <= 0 || tile.width() <= 0 || tile.height() <= 0) {
            return;
        }
        for (int tileX = 0; tileX < width; tileX += tile.width()) {
            int tileWidth = Math.min(tile.width(), width - tileX);
            for (int tileY = 0; tileY < height; tileY += tile.height()) {
                int tileHeight = Math.min(tile.height(), height - tileY);
                this.emitSpriteStretch(context, sprite, x + tileX, y + tileY, tileWidth, tileHeight, color);
            }
        }
    }

    private void emitSpriteNineSlice(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling.NineSlice nineSlice, int x, int y, int width, int height, int color) {
        int tileWidth;
        int tileX;
        if (width == nineSlice.width() && height == nineSlice.height()) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
            return;
        }
        GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
        int left = Math.min(border.left(), width / 2);
        int top = Math.min(border.top(), height / 2);
        int right = Math.min(border.right(), width / 2);
        int bottom = Math.min(border.bottom(), height / 2);
        if (width == nineSlice.width()) {
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + width, y + top, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV((float)top / (float)nineSlice.height()), color);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.height() - top - bottom) {
                int tileHeight = Math.min(nineSlice.height() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.atlasLocation(), x, y + tileY, x + nineSlice.width(), y + tileY + tileHeight, sprite.getU0(), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU1(), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
            }
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y + height - bottom, x + width, y + height, sprite.getU0(), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU1(), sprite.getV1(), color);
            return;
        }
        if (height == nineSlice.height()) {
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + left, y + height, sprite.getU0(), sprite.getV0(), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV1(), color);
            for (int tileX2 = left; tileX2 < width - right; tileX2 += nineSlice.width() - left - right) {
                int tileWidth2 = Math.min(nineSlice.width() - left - right, width - right - tileX2);
                this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX2, y, x + tileX2 + tileWidth2, y + nineSlice.height(), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV0(), sprite.getU((float)(left + tileWidth2) / (float)nineSlice.width()), sprite.getV1(), color);
            }
            this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y, x + width, y + height, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV0(), sprite.getU1(), sprite.getV1(), color);
            return;
        }
        this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + left, y + right, sprite.getU0(), sprite.getV0(), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)right / (float)nineSlice.width()), color);
        this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y, x + width, y + top, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV0(), sprite.getU1(), sprite.getV((float)top / (float)nineSlice.height()), color);
        this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y + height - bottom, x + width, y + height, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU1(), sprite.getV1(), color);
        this.emitTextureBatched(context, sprite.atlasLocation(), x, y + height - bottom, x + left, y + height, sprite.getU0(), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV1(), color);
        for (tileX = left; tileX < width - right; tileX += nineSlice.width() - left - right) {
            tileWidth = Math.min(nineSlice.width() - left - right, width - right - tileX);
            this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX, y, x + tileX + tileWidth, y + top, sprite.getU((float)left / (float)nineSlice.width()), sprite.getV0(), sprite.getU((float)(left + tileWidth) / (float)nineSlice.width()), sprite.getV((float)top / (float)nineSlice.height()), color);
            this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX, y + height - bottom, x + tileX + tileWidth, y + height, sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)(nineSlice.height() - bottom) / (float)nineSlice.height()), sprite.getU((float)(left + tileWidth) / (float)nineSlice.width()), sprite.getV1(), color);
        }
        for (int tileY = top; tileY < height - bottom; tileY += nineSlice.height() - top - bottom) {
            int tileHeight = Math.min(nineSlice.height() - top - bottom, height - bottom - tileY);
            this.emitTextureBatched(context, sprite.atlasLocation(), x, y + tileY, x + left, y + tileY + tileHeight, sprite.getU0(), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
            this.emitTextureBatched(context, sprite.atlasLocation(), x + width - right, y + tileY, x + width, y + tileY + tileHeight, sprite.getU((float)(nineSlice.width() - right) / (float)nineSlice.width()), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU1(), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
        }
        for (tileX = left; tileX < width - right; tileX += nineSlice.width() - left - right) {
            tileWidth = Math.min(nineSlice.width() - left - right, width - right - tileX);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.height() - top - bottom) {
                int tileHeight = Math.min(nineSlice.height() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.atlasLocation(), x + tileX, y + tileY, x + tileX + tileWidth, y + tileY + tileHeight, sprite.getU((float)left / (float)nineSlice.width()), sprite.getV((float)top / (float)nineSlice.height()), sprite.getU((float)(left + tileWidth) / (float)nineSlice.width()), sprite.getV((float)(top + tileHeight) / (float)nineSlice.height()), color);
            }
        }
    }

    private void emitSpriteStretch(GuiGraphics context, TextureAtlasSprite sprite, int x, int y, int width, int height, int color) {
        this.emitTextureBatched(context, sprite.atlasLocation(), x, y, x + width, y + height, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), color);
    }

    private void emitTextureBatched(GuiGraphics context, ResourceLocation texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix3x2fStack matrix = context.pose();
        Vector2f v1 = matrix.transformPosition(new Vector2f(minX, minY));
        Vector2f v2 = matrix.transformPosition(new Vector2f(minX, maxY));
        Vector2f v3 = matrix.transformPosition(new Vector2f(maxX, maxY));
        Vector2f v4 = matrix.transformPosition(new Vector2f(maxX, minY));
        emits.add(new TextureEmit(v1.x, v1.y, v2.x, v2.y, v3.x, v3.y, v4.x, v4.y, minU, minV, maxU, maxV, color));
    }

    public void draw(GuiGraphics context, TextureManager textureManager, final ScreenRectangle scissorArea) {
        if (this.batch.isEmpty()) {
            return;
        }
        for (Map.Entry<ResourceLocation, List<TextureEmit>> entry : this.batch.entrySet()) {
            final GpuTextureView texture = textureManager.getTexture(entry.getKey()).getTextureView();
            List<TextureEmit> emits = entry.getValue();
            final ScreenRectangle bounds = TextureBatchedRenderer.calcBounds(emits);
            final List<TextureEmit> emitsCopy = List.copyOf(emits);
            DrawContextAccess contextAccess = (DrawContextAccess)context;
            contextAccess.getState().submitGuiElement(new GuiElementRenderState(){

                public void buildVertices(VertexConsumer vc, float depth) {
                    for (TextureEmit emit : emitsCopy) {
                        vc.addVertex(emit.x1, emit.y1, depth).setUv(emit.minU, emit.minV).setColor(emit.color);
                        vc.addVertex(emit.x2, emit.y2, depth).setUv(emit.minU, emit.maxV).setColor(emit.color);
                        vc.addVertex(emit.x3, emit.y3, depth).setUv(emit.maxU, emit.maxV).setColor(emit.color);
                        vc.addVertex(emit.x4, emit.y4, depth).setUv(emit.maxU, emit.minV).setColor(emit.color);
                    }
                }

                public RenderPipeline pipeline() {
                    return RenderPipelines.GUI_TEXTURED;
                }

                public TextureSetup textureSetup() {
                    return TextureSetup.singleTexture((GpuTextureView)texture);
                }

                public ScreenRectangle scissorArea() {
                    return scissorArea;
                }

                public ScreenRectangle bounds() {
                    return bounds;
                }
            });
        }
        this.batch.clear();
    }

    @NotNull
    private static ScreenRectangle calcBounds(List<TextureEmit> emits) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (TextureEmit emit : emits) {
            minX = Math.min(minX, emit.x1);
            minX = Math.min(minX, emit.x2);
            minX = Math.min(minX, emit.x3);
            minX = Math.min(minX, emit.x4);
            minY = Math.min(minY, emit.y1);
            minY = Math.min(minY, emit.y2);
            minY = Math.min(minY, emit.y3);
            minY = Math.min(minY, emit.y4);
            maxX = Math.max(maxX, emit.x1);
            maxX = Math.max(maxX, emit.x2);
            maxX = Math.max(maxX, emit.x3);
            maxX = Math.max(maxX, emit.x4);
            maxY = Math.max(maxY, emit.y1);
            maxY = Math.max(maxY, emit.y2);
            maxY = Math.max(maxY, emit.y3);
            maxY = Math.max(maxY, emit.y4);
        }
        return new ScreenRectangle(Mth.floor((float)minX), Mth.floor((float)minY), Mth.ceil((float)(maxX - minX)), Mth.ceil((float)(maxY - minY)));
    }

    private record TextureEmit(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float minU, float minV, float maxU, float maxV, int color) {
    }
}

