/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ItemStackCondition
implements Operation<ItemStack, Boolean> {
    private final ItemPredicate predicate;
    private final Optional<NbtPredicate> optNbt;

    private ItemStackCondition(ItemPredicate predicate, Optional<NbtPredicate> optNbt) {
        this.predicate = predicate;
        this.optNbt = optNbt;
    }

    public static void register() {
        BuiltinPrototypes.ITEM_STACK.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, ItemStackCondition::parse);
    }

    public static Result<ItemStackCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(rootObject -> ItemStackCondition.parse(rootObject, context), context));
    }

    public static Result<ItemStackCondition, Problem> parse(JsonObject rootObject, OperationConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optItem = rootObject.get("item").getSuccess().flatMap(itemElement -> BuiltinJson.parseItemOrItemTag(itemElement).ifFailure(problems::add).getSuccess());
        Optional<NbtPredicate> optNbt = rootObject.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbtPredicate(nbtElement).ifFailure(problems::add).getSuccess());
        Optional optComponents = rootObject.get("components").getSuccess().flatMap(componentsElement -> BuiltinJson.parseComponentPredicate(componentsElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess());
        Optional optPredicates = rootObject.get("predicates").getSuccess().flatMap(predicatesElement -> BuiltinJson.parseItemSubPredicates(predicatesElement, (RegistryAccess)context.getServer().registryAccess()).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new ItemStackCondition(new ItemPredicate(optItem, MinMaxBounds.Ints.ANY, optComponents.orElse(DataComponentPredicate.EMPTY), optPredicates.orElseGet(Map::of)), optNbt));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(ItemStack itemStack) {
        return Optional.of(this.predicate.test(itemStack) && this.optNbt.map(nbt -> nbt.matches(itemStack)).orElse(true) != false);
    }
}

