/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2105;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ItemStackCondition
implements Operation<class_1799, Boolean> {
    private final Optional<class_6885<class_1792>> optItemEntries;
    private final Optional<class_2105> optNbt;

    private ItemStackCondition(Optional<class_6885<class_1792>> optItemEntries, Optional<class_2105> optNbt) {
        this.optItemEntries = optItemEntries;
        this.optNbt = optNbt;
    }

    public static void register() {
        BuiltinPrototypes.ITEM_STACK.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, ItemStackCondition::parse);
    }

    public static Result<ItemStackCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(ItemStackCondition::parse, context));
    }

    public static Result<ItemStackCondition, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<class_6885<class_1792>> optItem = rootObject.get("item").getSuccess().flatMap(itemElement -> BuiltinJson.parseItemOrItemTag(itemElement).ifFailure(problems::add).getSuccess());
        Optional<class_2105> optNbt = rootObject.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbtPredicate(nbtElement).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new ItemStackCondition(optItem, optNbt));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(class_1799 itemStack) {
        return Optional.of(this.optItemEntries.map(itemEntries -> itemEntries.method_40241((class_6880)itemStack.method_7909().method_40131())).orElse(true) != false && this.optNbt.map(nbt -> nbt.method_9074(itemStack)).orElse(true) != false);
    }
}

