/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import io.netty.buffer.Unpooled;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.mixin.GameRulesInvoker;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.setup.ServerPlatform;
import net.puffish.skillsmod.server.setup.ServerRegistrar;

public class FabricMain
implements ModInitializer {
    public void onInitialize() {
        SkillsMod.setup(FabricLoader.getInstance().getConfigDir(), new ServerRegistrarImpl(), new ServerEventReceiverImpl(), new ServerPacketSenderImpl(), new ServerPlatformImpl());
    }

    private static class ServerRegistrarImpl
    implements ServerRegistrar {
        private ServerRegistrarImpl() {
        }

        @Override
        public <V, T extends V> void register(class_2378<V> registry, class_2960 id, T entry) {
            class_2378.method_10230(registry, (class_2960)id, entry);
        }

        @Override
        public <T extends class_1928.class_4315<T>> class_1928.class_4313<T> registerGameRule(String name, class_1928.class_5198 category, class_1928.class_4314<T> type) {
            return GameRulesInvoker.invokeRegister(name, category, type);
        }

        @Override
        public <A extends ArgumentType<?>> void registerArgumentType(class_2960 id, Class<A> clazz, class_2314<A> serializer) {
            class_2316.method_10017((String)id.toString(), clazz, serializer);
        }

        @Override
        public <T extends InPacket> void registerInPacket(class_2960 id, Function<class_2540, T> reader, ServerPacketHandler<T> handler) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handler2, buf, responseSender) -> {
                InPacket packet = (InPacket)reader.apply(buf);
                server.execute(() -> handler.handle(player, packet));
            });
        }

        @Override
        public void registerOutPacket(class_2960 id) {
        }
    }

    private static class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            ServerLifecycleEvents.SERVER_STARTING.register(eventListener::onServerStarting);
            ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> eventListener.onServerReload(server));
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> eventListener.onPlayerJoin(handler.field_14140));
            ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> eventListener.onPlayerLeave(handler.field_14140));
            CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> eventListener.onCommandsRegister((CommandDispatcher<class_2168>)dispatcher));
        }
    }

    private static class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(class_3222 player, OutPacket packet) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            packet.write(buf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)buf);
        }
    }

    private static class ServerPlatformImpl
    implements ServerPlatform {
        private ServerPlatformImpl() {
        }

        @Override
        public boolean isFakePlayer(class_3222 player) {
            return false;
        }

        @Override
        public boolean isModLoaded(String id) {
            return FabricLoader.getInstance().isModLoaded(id);
        }
    }
}

