/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators;

import fabric.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import java.awt.Color;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class DamageDirectionIndicatorRenderer {
    private static class_1657 player = HealthIndicatorsCommon.client.field_1724;
    private static int timeSinceLastDamage = Integer.MAX_VALUE;
    private static class_1309 attacker;

    public static void markDamageToPlayer(class_1309 livingEntity) {
        timeSinceLastDamage = 0;
        attacker = livingEntity;
    }

    public static void tick() {
        player = HealthIndicatorsCommon.client.field_1724;
        if (timeSinceLastDamage != Integer.MAX_VALUE) {
            ++timeSinceLastDamage;
        }
        if (attacker == null || attacker.method_29504() || attacker.method_31481()) {
            timeSinceLastDamage = Integer.MAX_VALUE;
            attacker = null;
        }
        if (timeSinceLastDamage == Integer.MAX_VALUE) {
            attacker = null;
        }
    }

    public static void render(class_332 drawContext, float tickDelta) {
        if (player == null) {
            return;
        }
        if (timeSinceLastDamage <= ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_visibility_time * 20 && attacker != null) {
            int fadeDelay;
            class_243 playerPos = player.method_73189();
            class_243 attackerPos = attacker.method_73189();
            double deltaX = attackerPos.field_1352 - playerPos.field_1352;
            double deltaZ = attackerPos.field_1350 - playerPos.field_1350;
            float yawToAttacker = (float)Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0f;
            yawToAttacker = class_3532.method_15393((float)yawToAttacker);
            float deltaYaw = class_3532.method_15393((float)(yawToAttacker - player.method_36454()));
            int centerX = drawContext.method_51421() / 2;
            int centerY = drawContext.method_51443() / 2;
            float radius = 24.0f;
            float angle = (float)Math.toRadians(deltaYaw);
            float indicatorX = (float)centerX + radius * (float)Math.sin(angle);
            float indicatorY = (float)centerY - radius * (float)Math.cos(angle);
            int alpha = 255;
            if (((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_fade_out && timeSinceLastDamage >= (fadeDelay = (((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_visibility_time - ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_fade_out_time) * 20)) {
                float progress = Math.min((float)(timeSinceLastDamage - fadeDelay) / (float)(((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_fade_out_time * 20), 1.0f);
                alpha = 255 - (int)(255.0f * progress);
            }
            float scale = ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_scale;
            Color color = ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_color;
            int argb = alpha << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
            float x1 = -3.0f * scale;
            float y1 = 4.0f * scale;
            float x2 = 3.0f * scale;
            float y2 = 4.0f * scale;
            float x3 = 0.0f;
            float y3 = -4.0f * scale;
            float sin = class_3532.method_15374((float)angle);
            float cos = class_3532.method_15362((float)angle);
            float v1x = x1 * cos - y1 * sin + indicatorX;
            float v1y = x1 * sin + y1 * cos + indicatorY;
            float v2x = x2 * cos - y2 * sin + indicatorX;
            float v2y = x2 * sin + y2 * cos + indicatorY;
            float v3x = x3 * cos - y3 * sin + indicatorX;
            float v3y = x3 * sin + y3 * cos + indicatorY;
            float[] xs = new float[]{v1x, v2x, v3x};
            float[] ys = new float[]{v1y, v2y, v3y};
            DamageDirectionIndicatorRenderer.sortVerticesByY(xs, ys);
            DamageDirectionIndicatorRenderer.drawTriangle(drawContext, xs, ys, argb);
        }
    }

    private static void sortVerticesByY(float[] xs, float[] ys) {
        if (ys[0] > ys[1]) {
            DamageDirectionIndicatorRenderer.swap(xs, ys, 0, 1);
        }
        if (ys[0] > ys[2]) {
            DamageDirectionIndicatorRenderer.swap(xs, ys, 0, 2);
        }
        if (ys[1] > ys[2]) {
            DamageDirectionIndicatorRenderer.swap(xs, ys, 1, 2);
        }
    }

    private static void swap(float[] xs, float[] ys, int i, int j) {
        float tx = xs[i];
        xs[i] = xs[j];
        xs[j] = tx;
        float ty = ys[i];
        ys[i] = ys[j];
        ys[j] = ty;
    }

    private static void drawTriangle(class_332 context, float[] xs, float[] ys, int color) {
        float minY = ys[0];
        float midY = ys[1];
        float maxY = ys[2];
        if (minY == maxY) {
            return;
        }
        for (int y = (int)Math.floor(minY); y <= (int)Math.ceil(maxY); ++y) {
            float xb;
            float xa;
            boolean inSecondHalf;
            if ((float)y < minY || (float)y > maxY) continue;
            boolean bl = inSecondHalf = (float)y > midY;
            if (!inSecondHalf) {
                xa = DamageDirectionIndicatorRenderer.interpolate(xs[0], ys[0], xs[1], ys[1], y);
                xb = DamageDirectionIndicatorRenderer.interpolate(xs[0], ys[0], xs[2], ys[2], y);
            } else {
                xa = DamageDirectionIndicatorRenderer.interpolate(xs[1], ys[1], xs[2], ys[2], y);
                xb = DamageDirectionIndicatorRenderer.interpolate(xs[0], ys[0], xs[2], ys[2], y);
            }
            if (xa > xb) {
                float tmp = xa;
                xa = xb;
                xb = tmp;
            }
            context.method_25294((int)xa, y, (int)xb + 1, y + 1, color);
        }
    }

    private static float interpolate(float x1, float y1, float x2, float y2, float y) {
        if (y1 == y2) {
            return x1;
        }
        return x1 + (x2 - x1) * (y - y1) / (y2 - y1);
    }
}

