/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.config;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.Boolean;
import dev.isxander.yacl3.config.v2.api.autogen.ColorField;
import dev.isxander.yacl3.config.v2.api.autogen.CustomImage;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleField;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleSlider;
import dev.isxander.yacl3.config.v2.api.autogen.EnumCycler;
import dev.isxander.yacl3.config.v2.api.autogen.FloatSlider;
import dev.isxander.yacl3.config.v2.api.autogen.IntField;
import dev.isxander.yacl3.config.v2.api.autogen.IntSlider;
import dev.isxander.yacl3.config.v2.api.autogen.Label;
import dev.isxander.yacl3.config.v2.api.autogen.ListGroup;
import dev.isxander.yacl3.config.v2.api.autogen.MasterTickBox;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import fabric.io.github.adytech99.healthindicators.config.EntitiesListGroup;
import fabric.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import fabric.io.github.adytech99.healthindicators.enums.MessageTypeEnum;
import java.awt.Color;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ModConfig {
    public static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("health_indicators_config.json");
    public static final ConfigClassHandler<ModConfig> HANDLER = ConfigClassHandler.createBuilder(ModConfig.class).id(class_2960.method_60655((String)"healthindicators", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(CONFIG_PATH).build()).build();
    @Label
    @AutoGen(category="filters")
    private final class_2561 filtersProTip = class_2561.method_43470((String)"Pro Tip: You can temporarily override the below criteria and force health display for all living entities by holding the Right-Arrow key (customizable)").method_27692(class_124.field_1065);
    @Label
    private final class_2561 filtersTypeLabel = class_2561.method_43470((String)"Enable health display based on entity type").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean passive_mobs = true;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean hostile_mobs = true;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @MasterTickBox(value={"override_players"})
    public boolean players = true;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean self = false;
    @SerialEntry
    @AutoGen(category="filters", group="entity_type")
    @TickBox
    public boolean show_through_walls = false;
    @SerialEntry
    @AutoGen(category="filters")
    @Boolean(formatter=Boolean.Formatter.CUSTOM)
    public boolean blacklistOrWhitelist = true;
    @SerialEntry
    @AutoGen(category="filters")
    @ListGroup(valueFactory=EntitiesListGroup.class, controllerFactory=EntitiesListGroup.class)
    public List<String> list = Lists.newArrayList((Object[])new String[]{"minecraft:armor_stand"});
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 filtersAdvancedLabel = class_2561.method_43470((String)"Show for...").method_27692(class_124.field_1075);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players", "time_after_hit"})
    public boolean after_attack = false;
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @IntSlider(min=0, max=120, step=1)
    public int time_after_hit = 60;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 damaged_only_label = class_2561.method_43470((String)" ").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players", "max_health_percentage"})
    public boolean damaged_only = false;
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @IntSlider(min=0, max=100, step=1)
    public int max_health_percentage = 100;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 looking_at_label = class_2561.method_43470((String)" ").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players", "reach"})
    public boolean looking_at = false;
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @IntField(min=0, max=1024)
    public int reach = 3;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 distance_label = class_2561.method_43470((String)" ").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @MasterTickBox(value={"override_players", "distance"})
    public boolean within_distance = false;
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @IntSlider(min=0, max=512, step=4)
    public int distance = 64;
    @Label
    @AutoGen(category="filters", group="advanced")
    private final class_2561 override_players_label = class_2561.method_43470((String)"Overrides").method_27692(class_124.field_1056);
    @SerialEntry
    @AutoGen(category="filters", group="advanced")
    @TickBox
    public boolean override_players = false;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @EnumCycler
    public HealthDisplayTypeEnum indicator_type = HealthDisplayTypeEnum.HEARTS;
    @AutoGen(category="appearance", group="indicator_type")
    @Label
    private final class_2561 heart_type_settings_label = class_2561.method_43470((String)"Settings for the heart-type indicator");
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @IntField
    public int icons_per_row = 10;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @Boolean
    public boolean use_vanilla_textures = false;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @IntSlider(min=0, max=100, step=1)
    public int health_bar_opacity = 100;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @Boolean
    public boolean show_heart_effects = true;
    @AutoGen(category="appearance", group="indicator_type")
    @Label
    private final class_2561 number_type_settings_label = class_2561.method_43470((String)"Settings for the number-type indicator");
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @ColorField
    public Color number_color = Color.RED;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @Boolean
    public boolean render_number_display_shadow = false;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @IntSlider(min=0, max=12, step=1)
    public int decimal_places = 1;
    public boolean render_number_display_background_color = false;
    public Color number_display_background_color = Color.BLACK;
    @AutoGen(category="appearance", group="indicator_type")
    @Label
    private final class_2561 common_type_settings_label = class_2561.method_43470((String)"Common settings for all indicator types");
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @MasterTickBox(value={"max_health"})
    public boolean percentage_based_health = false;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @IntSlider(min=1, max=100, step=1)
    public int max_health = 20;
    @SerialEntry
    @AutoGen(category="appearance", group="indicator_type")
    @FloatSlider(min=0.0f, max=0.1f, step=0.005f, format="%.3f")
    public float size = 0.025f;
    @SerialEntry
    @AutoGen(category="appearance", group="offset")
    @DoubleField
    public double display_offset = 0.0;
    @SerialEntry
    @AutoGen(category="appearance", group="offset")
    @DoubleSlider(min=0.0, max=10.0, step=0.5)
    public double offset_step_size = 1.0;
    @SerialEntry
    @AutoGen(category="appearance", group="offset")
    @Boolean
    public boolean force_higher_offset_for_players = false;
    @SerialEntry
    @AutoGen(category="messages", group="messages_appearance")
    @EnumCycler
    public MessageTypeEnum message_type = MessageTypeEnum.ACTIONBAR;
    @SerialEntry
    @AutoGen(category="messages", group="messages_appearance")
    @Boolean(colored=true)
    public boolean colored_messages = true;
    @Label
    @AutoGen(category="messages", group="commands")
    private final class_2561 commandsRestartWarning = class_2561.method_43470((String)"For this section, a restart is required to apply any modifications").method_27692(class_124.field_1061);
    @SerialEntry
    @AutoGen(category="messages", group="commands")
    @Boolean(formatter=Boolean.Formatter.YES_NO)
    public boolean enable_commands = true;
    @SerialEntry
    @AutoGen(category="damage_direction_indicators")
    @CustomImage(value="images/damage_direction_indicator_example.png", width=2160, height=2160)
    @Boolean
    public boolean enable_damage_direction_indicators = false;
    @SerialEntry
    @AutoGen(category="damage_direction_indicators")
    @IntSlider(min=1, max=8, step=1)
    public int damage_direction_indicators_scale = 2;
    @SerialEntry
    @AutoGen(category="damage_direction_indicators")
    @ColorField
    public Color damage_direction_indicators_color = Color.RED;
    @SerialEntry
    @AutoGen(category="damage_direction_indicators")
    @IntSlider(min=1, max=8, step=1)
    public int damage_direction_indicators_visibility_time = 4;
    @SerialEntry
    @AutoGen(category="damage_direction_indicators")
    @MasterTickBox(value={"damage_direction_indicators_fade_out_time"})
    public boolean damage_direction_indicators_fade_out = true;
    @SerialEntry
    @AutoGen(category="damage_direction_indicators")
    @IntSlider(min=0, max=7, step=1)
    public int damage_direction_indicators_fade_out_time = 3;

    public static class_437 createScreen(@Nullable class_437 parent) {
        return HANDLER.generateGui().generateScreen(parent);
    }

    public class_437 createConfigScreen(class_437 parent) {
        if (Platform.isModLoaded((String)"yet_another_config_lib_v3")) {
            return ModConfig.createScreen(parent);
        }
        return null;
    }
}

