/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators;

import java.awt.Color;
import neoforge.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DamageDirectionIndicatorRenderer {
    private static Player player = HealthIndicatorsCommon.client.player;
    private static int timeSinceLastDamage = Integer.MAX_VALUE;
    private static LivingEntity attacker;

    public static void markDamageToPlayer(LivingEntity livingEntity) {
        timeSinceLastDamage = 0;
        attacker = livingEntity;
    }

    public static void tick() {
        player = HealthIndicatorsCommon.client.player;
        if (timeSinceLastDamage != Integer.MAX_VALUE) {
            ++timeSinceLastDamage;
        }
        if (attacker == null || attacker.isDeadOrDying() || attacker.isRemoved()) {
            timeSinceLastDamage = Integer.MAX_VALUE;
            attacker = null;
        }
        if (timeSinceLastDamage == Integer.MAX_VALUE) {
            attacker = null;
        }
    }

    public static void render(GuiGraphics drawContext, float tickDelta) {
        if (player == null) {
            return;
        }
        if (timeSinceLastDamage <= ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_visibility_time * 20 && attacker != null) {
            int fadeDelay;
            Vec3 playerPos = player.position();
            Vec3 attackerPos = attacker.position();
            double deltaX = attackerPos.x - playerPos.x;
            double deltaZ = attackerPos.z - playerPos.z;
            float yawToAttacker = (float)Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0f;
            yawToAttacker = Mth.wrapDegrees((float)yawToAttacker);
            float deltaYaw = Mth.wrapDegrees((float)(yawToAttacker - player.getYRot()));
            int centerX = drawContext.guiWidth() / 2;
            int centerY = drawContext.guiHeight() / 2;
            float radius = 24.0f;
            float angle = (float)Math.toRadians(deltaYaw);
            float indicatorX = (float)centerX + radius * (float)Math.sin(angle);
            float indicatorY = (float)centerY - radius * (float)Math.cos(angle);
            int alpha = 255;
            if (((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_fade_out && timeSinceLastDamage >= (fadeDelay = (((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_visibility_time - ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_fade_out_time) * 20)) {
                float progress = Math.min((float)(timeSinceLastDamage - fadeDelay) / (float)(((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_fade_out_time * 20), 1.0f);
                alpha = 255 - (int)(255.0f * progress);
            }
            float scale = ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_scale;
            Color color = ((ModConfig)ModConfig.HANDLER.instance()).damage_direction_indicators_color;
            int argb = alpha << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
            float x1 = -3.0f * scale;
            float y1 = 4.0f * scale;
            float x2 = 3.0f * scale;
            float y2 = 4.0f * scale;
            float x3 = 0.0f;
            float y3 = -4.0f * scale;
            float sin = Mth.sin((float)angle);
            float cos = Mth.cos((float)angle);
            float v1x = x1 * cos - y1 * sin + indicatorX;
            float v1y = x1 * sin + y1 * cos + indicatorY;
            float v2x = x2 * cos - y2 * sin + indicatorX;
            float v2y = x2 * sin + y2 * cos + indicatorY;
            float v3x = x3 * cos - y3 * sin + indicatorX;
            float v3y = x3 * sin + y3 * cos + indicatorY;
            float[] xs = new float[]{v1x, v2x, v3x};
            float[] ys = new float[]{v1y, v2y, v3y};
            DamageDirectionIndicatorRenderer.sortVerticesByY(xs, ys);
            DamageDirectionIndicatorRenderer.drawTriangle(drawContext, xs, ys, argb);
        }
    }

    private static void sortVerticesByY(float[] xs, float[] ys) {
        if (ys[0] > ys[1]) {
            DamageDirectionIndicatorRenderer.swap(xs, ys, 0, 1);
        }
        if (ys[0] > ys[2]) {
            DamageDirectionIndicatorRenderer.swap(xs, ys, 0, 2);
        }
        if (ys[1] > ys[2]) {
            DamageDirectionIndicatorRenderer.swap(xs, ys, 1, 2);
        }
    }

    private static void swap(float[] xs, float[] ys, int i, int j) {
        float tx = xs[i];
        xs[i] = xs[j];
        xs[j] = tx;
        float ty = ys[i];
        ys[i] = ys[j];
        ys[j] = ty;
    }

    private static void drawTriangle(GuiGraphics context, float[] xs, float[] ys, int color) {
        float minY = ys[0];
        float midY = ys[1];
        float maxY = ys[2];
        if (minY == maxY) {
            return;
        }
        for (int y = (int)Math.floor(minY); y <= (int)Math.ceil(maxY); ++y) {
            float xb;
            float xa;
            boolean inSecondHalf;
            if ((float)y < minY || (float)y > maxY) continue;
            boolean bl = inSecondHalf = (float)y > midY;
            if (!inSecondHalf) {
                xa = DamageDirectionIndicatorRenderer.interpolate(xs[0], ys[0], xs[1], ys[1], y);
                xb = DamageDirectionIndicatorRenderer.interpolate(xs[0], ys[0], xs[2], ys[2], y);
            } else {
                xa = DamageDirectionIndicatorRenderer.interpolate(xs[1], ys[1], xs[2], ys[2], y);
                xb = DamageDirectionIndicatorRenderer.interpolate(xs[0], ys[0], xs[2], ys[2], y);
            }
            if (xa > xb) {
                float tmp = xa;
                xa = xb;
                xb = tmp;
            }
            context.fill((int)xa, y, (int)xb + 1, y + 1, color);
        }
    }

    private static float interpolate(float x1, float y1, float x2, float y2, float y) {
        if (y1 == y2) {
            return x1;
        }
        return x1 + (x2 - x1) * (y - y1) / (y2 - y1);
    }
}

