/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators;

import dev.architectury.event.events.client.ClientGuiEvent;
import neoforge.io.github.adytech99.healthindicators.DamageDirectionIndicatorRenderer;
import neoforge.io.github.adytech99.healthindicators.HudRenderer;
import neoforge.io.github.adytech99.healthindicators.RenderTracker;
import neoforge.io.github.adytech99.healthindicators.config.Config;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.util.ConfigUtils;
import neoforge.io.github.adytech99.healthindicators.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthIndicatorsCommon {
    public static final String MOD_ID = "healthindicators";
    public static Minecraft client = Minecraft.getInstance();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"healthindicators");
    public static final KeyMapping.Category HEALTH_INDICATORS_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"healthindicators", (String)"main"));
    private static boolean changed = false;
    private static boolean openConfig = false;

    public static void init() {
        ModConfig.HANDLER.load();
        Config.load();
        ClientGuiEvent.RENDER_HUD.register(HealthIndicatorsCommon::onHudRender);
        client = Minecraft.getInstance();
        LOGGER.info("Never be heartless!");
    }

    public static void tick() {
        if (openConfig) {
            Screen configScreen = ModConfig.createScreen(HealthIndicatorsCommon.client.screen);
            client.setScreen(configScreen);
            openConfig = false;
        }
        if (client == null || HealthIndicatorsCommon.client.level == null) {
            client = Minecraft.getInstance();
            return;
        }
        if (changed && HealthIndicatorsCommon.client.level != null && HealthIndicatorsCommon.client.level.getGameTime() % 200L == 0L) {
            ModConfig.HANDLER.save();
            changed = false;
        }
        RenderTracker.tick(client);
        DamageDirectionIndicatorRenderer.tick();
    }

    public static void onHudRender(GuiGraphics drawContext1, DeltaTracker renderTickCounter1) {
        if (RenderTracker.getTrackedEntity() != null) {
            HudRenderer.onHudRender(drawContext1, renderTickCounter1);
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).enable_damage_direction_indicators) {
            DamageDirectionIndicatorRenderer.render(drawContext1, renderTickCounter1.getRealtimeDeltaTicks());
        }
    }

    public static void openConfig() {
        try {
            openConfig = HealthIndicatorsCommon.client.level != null;
        }
        catch (NullPointerException e) {
            openConfig = false;
        }
    }

    public static void enableHeartsRendering() {
        Config.setHeartsRenderingEnabled(!Config.getHeartsRenderingEnabled());
        if (client != null && HealthIndicatorsCommon.client.player != null) {
            ChatFormatting formatting = ((ModConfig)ModConfig.HANDLER.instance()).colored_messages ? (Config.getHeartsRenderingEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED) : ChatFormatting.WHITE;
            ConfigUtils.sendMessage(HealthIndicatorsCommon.client.player, (Component)Component.literal((String)((Config.getHeartsRenderingEnabled() ? "Enabled" : "Disabled") + " Health Indicators")).withStyle(formatting));
        }
    }

    public static void enableArmorRendering() {
        Config.setArmorRenderingEnabled(!Config.getArmorRenderingEnabled());
        if (client != null && HealthIndicatorsCommon.client.player != null) {
            ChatFormatting formatting = ((ModConfig)ModConfig.HANDLER.instance()).colored_messages ? (Config.getArmorRenderingEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED) : ChatFormatting.WHITE;
            ConfigUtils.sendMessage(HealthIndicatorsCommon.client.player, (Component)Component.literal((String)((Config.getArmorRenderingEnabled() ? "Enabled" : "Disabled") + " Armor Indicators")).withStyle(formatting));
        }
    }

    public static void increaseOffset() {
        ((ModConfig)ModConfig.HANDLER.instance()).display_offset += ((ModConfig)ModConfig.HANDLER.instance()).offset_step_size;
        changed = true;
        if (client != null && HealthIndicatorsCommon.client.player != null) {
            ConfigUtils.sendMessage(HealthIndicatorsCommon.client.player, (Component)Component.literal((String)("Set heart offset to " + Util.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
        }
    }

    public static void decreaseOffset() {
        ((ModConfig)ModConfig.HANDLER.instance()).display_offset -= ((ModConfig)ModConfig.HANDLER.instance()).offset_step_size;
        changed = true;
        if (client != null && HealthIndicatorsCommon.client.player != null) {
            ConfigUtils.sendMessage(HealthIndicatorsCommon.client.player, (Component)Component.literal((String)("Set heart offset to " + Util.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
        }
    }

    public static void overrideFilters() {
        Config.setOverrideAllFiltersEnabled(true);
        if (client != null && HealthIndicatorsCommon.client.player != null) {
            ConfigUtils.sendOverlayMessage(HealthIndicatorsCommon.client.player, (Component)Component.literal((String)(" Config Criteria " + (Config.getOverrideAllFiltersEnabled() ? "Temporarily Overridden" : "Re-implemented"))));
        }
    }

    public static void disableOverrideFilters() {
        Config.setOverrideAllFiltersEnabled(false);
        HealthIndicatorsCommon.client.gui.setOverlayMessage((Component)Component.literal((String)""), false);
    }

    public static void openConfigScreen() {
        HealthIndicatorsCommon.openConfig();
    }
}

