/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.enums.ArmorTypeEnum;
import neoforge.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void drawHeart(Matrix4f model, VertexConsumer vertexConsumer, float x, HeartTypeEnum type, LivingEntity livingEntity) {
        RenderUtils.drawHeart(model, vertexConsumer, x, type, livingEntity, 1.0f, 0.0);
    }

    public static void drawHeart(Matrix4f model, VertexConsumer vertexConsumer, float x, HeartTypeEnum type, LivingEntity livingEntity, float opacity) {
        RenderUtils.drawHeart(model, vertexConsumer, x, type, livingEntity, opacity, 0.0);
    }

    public static void drawHeart(Matrix4f model, VertexConsumer vertexConsumer, float x, HeartTypeEnum type, LivingEntity livingEntity, float opacity, double squaredDistance) {
        RenderUtils.drawHeart(model, vertexConsumer, x, type, livingEntity, opacity, squaredDistance, false);
    }

    public static void drawHeart(Matrix4f model, VertexConsumer vertexConsumer, float x, HeartTypeEnum type, LivingEntity livingEntity, float opacity, double squaredDistance, boolean isObstructed) {
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        float z = 0.0f;
        if (!isObstructed) {
            float baseOffset = 0.01f;
            float distanceScale = 1.0f + (float)(Math.sqrt(squaredDistance) * (double)0.001f);
            float scaledOffset = baseOffset * distanceScale;
            z = type == HeartTypeEnum.EMPTY ? -scaledOffset : scaledOffset;
        }
        vertexConsumer.addVertex(model, x, 0.0f - heartSize, z).setUv(minU, maxV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
        vertexConsumer.addVertex(model, x - heartSize, 0.0f - heartSize, z).setUv(maxU, maxV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
        vertexConsumer.addVertex(model, x - heartSize, 0.0f, z).setUv(maxU, minV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
        vertexConsumer.addVertex(model, x, 0.0f, z).setUv(minU, minV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
    }

    public static void drawArmor(Matrix4f model, VertexConsumer vertexConsumer, float x, ArmorTypeEnum type) {
        RenderUtils.drawArmor(model, vertexConsumer, x, type, 1.0f, 0.0);
    }

    public static void drawArmor(Matrix4f model, VertexConsumer vertexConsumer, float x, ArmorTypeEnum type, float opacity) {
        RenderUtils.drawArmor(model, vertexConsumer, x, type, opacity, 0.0);
    }

    public static void drawArmor(Matrix4f model, VertexConsumer vertexConsumer, float x, ArmorTypeEnum type, float opacity, double squaredDistance) {
        RenderUtils.drawArmor(model, vertexConsumer, x, type, opacity, squaredDistance, false);
    }

    public static void drawArmor(Matrix4f model, VertexConsumer vertexConsumer, float x, ArmorTypeEnum type, float opacity, double squaredDistance, boolean isObstructed) {
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float armorSize = 9.0f;
        float z = 0.0f;
        if (!isObstructed) {
            float baseOffset = 0.01f;
            float distanceScale = 1.0f + (float)(Math.sqrt(squaredDistance) * (double)0.001f);
            float scaledOffset = baseOffset * distanceScale;
            z = type == ArmorTypeEnum.EMPTY ? -scaledOffset : scaledOffset;
        }
        vertexConsumer.addVertex(model, x, 0.0f - armorSize, z).setUv(minU, maxV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
        vertexConsumer.addVertex(model, x - armorSize, 0.0f - armorSize, z).setUv(maxU, maxV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
        vertexConsumer.addVertex(model, x - armorSize, 0.0f, z).setUv(maxU, minV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
        vertexConsumer.addVertex(model, x, 0.0f, z).setUv(minU, minV).setLight(0xF000F0).setColor(1.0f, 1.0f, 1.0f, opacity);
    }

    public static String getHealthText(LivingEntity livingEntity) {
        int decimalPlaces = ((ModConfig)ModConfig.HANDLER.instance()).decimal_places;
        float health = livingEntity.getHealth();
        float maxHealth = livingEntity.getMaxHealth();
        float absorption = livingEntity.getAbsorptionAmount();
        String healthStr = RenderUtils.formatToDecimalPlaces(health + absorption, decimalPlaces);
        String maxHealthStr = RenderUtils.formatToDecimalPlaces(maxHealth, decimalPlaces);
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            float percentage = (health + absorption) / maxHealth * 100.0f;
            String percentageStr = RenderUtils.formatToDecimalPlaces(percentage, decimalPlaces);
            return percentageStr + " %";
        }
        return healthStr + " / " + maxHealthStr;
    }

    private static String formatToDecimalPlaces(float value, int decimalPlaces) {
        if (decimalPlaces == 0) {
            return String.format("%.0f", Float.valueOf(value));
        }
        String decimalPlaces2 = String.valueOf(decimalPlaces);
        return String.format("%." + decimalPlaces2 + "f", Float.valueOf(value));
    }
}

