/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.block;

import com.modvane.hologenica.block.ImprinterBlock;
import com.modvane.hologenica.block.NeurocellBlock;
import com.modvane.hologenica.block.ReformerBlock;
import com.modvane.hologenica.block.entity.NeurocellBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NeurolinkBlock
extends Block {
    public static final MapCodec<NeurolinkBlock> CODEC = NeurolinkBlock.simpleCodec(NeurolinkBlock::new);
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    private static final VoxelShape CENTER_SHAPE = Block.box((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)6.0, (double)1.0, (double)0.0, (double)10.0, (double)5.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)6.0, (double)1.0, (double)10.0, (double)10.0, (double)5.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)10.0, (double)1.0, (double)6.0, (double)16.0, (double)5.0, (double)10.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)1.0, (double)6.0, (double)6.0, (double)5.0, (double)10.0);
    private static final VoxelShape UP_SHAPE = Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);

    public NeurolinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.getConnectionState(state, level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!oldState.is((Block)this)) {
            level.setBlock(pos, this.getConnectionState(state, (LevelAccessor)level, pos), 3);
        }
    }

    private BlockState getConnectionState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = this.canConnectTo(level, pos, Direction.NORTH);
        boolean south = this.canConnectTo(level, pos, Direction.SOUTH);
        boolean east = this.canConnectTo(level, pos, Direction.EAST);
        boolean west = this.canConnectTo(level, pos, Direction.WEST);
        boolean up = this.canConnectTo(level, pos, Direction.UP);
        boolean down = this.canConnectTo(level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity;
        BlockPos neighborPos = pos.relative(direction);
        BlockState neighborState = level.getBlockState(neighborPos);
        Block neighborBlock = neighborState.getBlock();
        if (neighborBlock instanceof NeurolinkBlock) {
            return true;
        }
        if (neighborBlock instanceof NeurocellBlock && (blockEntity = level.getBlockEntity(neighborPos)) instanceof NeurocellBlockEntity) {
            NeurocellBlockEntity neurocell = (NeurocellBlockEntity)blockEntity;
            return neurocell.acceptsConnectionFrom(direction.getOpposite());
        }
        return neighborBlock instanceof ReformerBlock || neighborBlock instanceof ImprinterBlock;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = CENTER_SHAPE;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        }
        return shape;
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }
}

