/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.block.entity;

import com.modvane.hologenica.menu.HologramMenu;
import com.modvane.hologenica.registry.HologenicaBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HologramBlockEntity
extends BlockEntity {
    private static final int DEFAULT_SCAN_SIZE = 32;
    private static final int DEFAULT_BLOCK_SIZE = 1;
    private static final boolean DEFAULT_TRANSPARENT = true;
    private static final boolean DEFAULT_ROTATION = true;
    private static final RenderStyle DEFAULT_STYLE = RenderStyle.CLASSIC;
    private int scanMinX;
    private int scanMaxX;
    private int scanMinZ;
    private int scanMaxZ;
    private boolean regionValid = false;
    private int scanSize = 32;
    private int blockSize = 1;
    private boolean transparentMode = true;
    private boolean rotationEnabled = true;
    private RenderStyle renderStyle = DEFAULT_STYLE;
    private int[][][] cachedTerrain = null;
    private boolean needsRescan = true;

    public HologramBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HologenicaBlockEntities.HOLOGRAM.get(), pos, state);
    }

    public void setupScanRegion() {
        BlockPos center = this.getBlockPos();
        int halfSize = this.scanSize / 2;
        this.scanMinX = center.getX() - halfSize;
        this.scanMaxX = center.getX() + halfSize - 1;
        this.scanMinZ = center.getZ() - halfSize;
        this.scanMaxZ = center.getZ() + halfSize - 1;
        int actualWidth = this.scanMaxX - this.scanMinX + 1;
        int actualDepth = this.scanMaxZ - this.scanMinZ + 1;
        this.regionValid = actualWidth == this.scanSize && actualDepth == this.scanSize;
        this.cachedTerrain = null;
        this.needsRescan = true;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public int[][][] getCachedTerrain() {
        return this.cachedTerrain;
    }

    public void setCachedTerrain(int[][][] terrain) {
        this.cachedTerrain = terrain;
        this.needsRescan = false;
    }

    public boolean needsRescan() {
        return this.needsRescan;
    }

    public void markForRescan() {
        this.needsRescan = true;
    }

    public boolean isTransparentMode() {
        return this.transparentMode;
    }

    public void toggleTransparency() {
        this.transparentMode = !this.transparentMode;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean isRotationEnabled() {
        return this.rotationEnabled;
    }

    public void toggleRotation() {
        this.rotationEnabled = !this.rotationEnabled;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public RenderStyle getRenderStyle() {
        return this.renderStyle;
    }

    public void cycleStyle() {
        this.renderStyle = switch (this.renderStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RenderStyle.REALISTIC;
            case 1 -> RenderStyle.CLASSIC;
        };
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public int getScanSize() {
        return this.scanSize;
    }

    public void setScanSize(int newSize) {
        this.scanSize = newSize;
        this.setupScanRegion();
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int newSize) {
        this.blockSize = newSize;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public int getScanMinX() {
        return this.scanMinX;
    }

    public int getScanMaxX() {
        return this.scanMaxX;
    }

    public int getScanMinZ() {
        return this.scanMinZ;
    }

    public int getScanMaxZ() {
        return this.scanMaxZ;
    }

    public boolean hasValidRegion() {
        return this.regionValid;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("ScanSize", this.scanSize);
        tag.putInt("BlockSize", this.blockSize);
        tag.putBoolean("TransparentMode", this.transparentMode);
        tag.putBoolean("RotationEnabled", this.rotationEnabled);
        tag.putString("RenderStyle", this.renderStyle.name());
        tag.putInt("ScanMinX", this.scanMinX);
        tag.putInt("ScanMaxX", this.scanMaxX);
        tag.putInt("ScanMinZ", this.scanMinZ);
        tag.putInt("ScanMaxZ", this.scanMaxZ);
        tag.putBoolean("RegionValid", this.regionValid);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        boolean hasBounds;
        super.loadAdditional(tag, registries);
        if (tag.contains("ScanSize")) {
            this.scanSize = tag.getInt("ScanSize");
        }
        if (tag.contains("BlockSize")) {
            this.blockSize = tag.getInt("BlockSize");
        }
        if (tag.contains("TransparentMode")) {
            this.transparentMode = tag.getBoolean("TransparentMode");
        }
        if (tag.contains("RotationEnabled")) {
            this.rotationEnabled = tag.getBoolean("RotationEnabled");
        }
        if (tag.contains("RenderStyle")) {
            try {
                this.renderStyle = RenderStyle.valueOf(tag.getString("RenderStyle"));
            }
            catch (IllegalArgumentException e) {
                this.renderStyle = DEFAULT_STYLE;
            }
        }
        boolean bl = hasBounds = tag.contains("ScanMinX") && tag.contains("ScanMaxX") && tag.contains("ScanMinZ") && tag.contains("ScanMaxZ");
        if (hasBounds) {
            this.scanMinX = tag.getInt("ScanMinX");
            this.scanMaxX = tag.getInt("ScanMaxX");
            this.scanMinZ = tag.getInt("ScanMinZ");
            this.scanMaxZ = tag.getInt("ScanMaxZ");
            this.regionValid = tag.getBoolean("RegionValid");
            int loadedWidth = this.scanMaxX - this.scanMinX + 1;
            int loadedDepth = this.scanMaxZ - this.scanMinZ + 1;
            if (loadedWidth != this.scanSize || loadedDepth != this.scanSize) {
                this.setupScanRegion();
            } else {
                this.cachedTerrain = null;
                this.needsRescan = true;
            }
        } else {
            this.setupScanRegion();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("ScanSize", this.scanSize);
        tag.putInt("BlockSize", this.blockSize);
        tag.putBoolean("TransparentMode", this.transparentMode);
        tag.putBoolean("RotationEnabled", this.rotationEnabled);
        tag.putString("RenderStyle", this.renderStyle.name());
        tag.putInt("ScanMinX", this.scanMinX);
        tag.putInt("ScanMaxX", this.scanMaxX);
        tag.putInt("ScanMinZ", this.scanMinZ);
        tag.putInt("ScanMaxZ", this.scanMaxZ);
        tag.putBoolean("RegionValid", this.regionValid);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new HologramMenu(containerId, playerInventory, this), (Component)Component.translatable((String)"block.hologenica.hologram"));
    }

    public static enum RenderStyle {
        CLASSIC,
        REALISTIC;

    }
}

